/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.dir;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDataStore
implements DataStore,
LockingManager {
    private File dir;
    private Map dataStores;
    private String[] createOrder;
    private List contents = null;

    private DirectoryDataStore() {
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public DirectoryDataStore(File f) throws MalformedURLException, IOException {
        this.dir = f;
        this.createOrder = FileDataStoreFinder.getAvailableFileExtentions().toArray(new String[0]);
        this.dataStores = new HashMap();
        this.load(f);
    }

    public DirectoryDataStore(File f, String[] co) throws MalformedURLException, IOException {
        this.dir = f;
        this.createOrder = co;
        this.dataStores = new HashMap();
        this.load(f);
    }

    private void load(File f) throws IOException, MalformedURLException {
        File[] children = f.listFiles();
        for (int i = 0; i < children.length; ++i) {
            AbstractFileDataStore afds;
            if (!children[i].isFile() || (afds = (AbstractFileDataStore)FileDataStoreFinder.getDataStore(children[i].toURI().toURL())) == null) continue;
            this.dataStores.put(afds.getTypeNames()[0], afds);
        }
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.dir);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.dir.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public String[] getTypeNames() throws IOException {
        HashSet<String> l = new HashSet<String>();
        for (AbstractFileDataStore afds : this.dataStores.values()) {
            String[] strs = afds.getTypeNames();
            if (strs == null) continue;
            for (int j = 0; j < strs.length; ++j) {
                l.add(strs[j]);
            }
        }
        return l.toArray(new String[l.size()]);
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getSchema();
        }
        return null;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        boolean notDone = true;
        for (int i = 0; notDone && i < this.createOrder.length; ++i) {
            AbstractFileDataStore afds;
            File f = new File(this.dir, featureType.getTypeName() + this.createOrder[i]);
            if (f.exists() || (afds = (AbstractFileDataStore)FileDataStoreFinder.getDataStore(f.toURI().toURL())) == null) continue;
            afds.createSchema(featureType);
            this.dataStores.put(featureType.getTypeName(), afds);
            notDone = false;
        }
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            afds.updateSchema(featureType);
        }
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureSource();
        }
        return null;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(query.getTypeName());
        if (afds != null) {
            return afds.getFeatureReader(query, transaction);
        }
        return null;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(filter, transaction);
        }
        return null;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(transaction);
        }
        return null;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriterAppend(transaction);
        }
        return null;
    }

    @Override
    public LockingManager getLockingManager() {
        return this;
    }

    @Override
    public boolean exists(String authID) {
        for (AbstractFileDataStore afds : this.dataStores.values()) {
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean release(String authID, Transaction transaction) throws IOException {
        for (AbstractFileDataStore afds : this.dataStores.values()) {
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return afds.getLockingManager().release(authID, transaction);
        }
        return false;
    }

    @Override
    public boolean refresh(String authID, Transaction transaction) throws IOException {
        for (AbstractFileDataStore afds : this.dataStores.values()) {
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return afds.getLockingManager().refresh(authID, transaction);
        }
        return false;
    }

    @Override
    public void unLockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().unLockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    @Override
    public void lockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().lockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    @Override
    public void dispose() {
        if (this.dataStores != null) {
            for (DataStore ds : this.dataStores.values()) {
                ds.dispose();
            }
            this.dataStores = null;
        }
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }
}

