/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.png;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMS;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class PNGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.png");
    private static final String MIME_TYPE = "image/png";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/png", "image/png8"};
    protected Boolean PNGNativeAcc;

    public PNGMapProducer(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS, wms);
        this.PNGNativeAcc = wms.getPNGNativeAcceleration();
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        String format;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ...");
        }
        if ((format = this.getOutputFormat()).equalsIgnoreCase("image/png8") || this.mapContext.getPaletteInverter() != null) {
            image = this.forceIndexed8Bitmask(image);
        }
        float quality = (float)(100 - this.wms.getPngCompression()) / 100.0f;
        new ImageWorker(image).writePNG((Object)outStream, "FILTERED", quality, this.PNGNativeAcc.booleanValue(), image.getColorModel() instanceof IndexColorModel);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ... done!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

