/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.responses;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.geoserver.wms.responses.MapDecorationLayout;
import org.vfny.geoserver.wms.WMSMapContext;

public class MetatiledMapDecorationLayout
extends MapDecorationLayout {
    private int tileSize = 3;

    public MetatiledMapDecorationLayout() {
    }

    public MetatiledMapDecorationLayout(int tileSize) {
        this.tileSize = tileSize;
    }

    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext mapContext) {
        int width = paintArea.width / this.tileSize;
        int height = paintArea.height / this.tileSize;
        for (int i = 0; i < this.tileSize; ++i) {
            for (int j = 0; j < this.tileSize; ++j) {
                int x = paintArea.x + paintArea.width * i / this.tileSize;
                int y = paintArea.y + paintArea.height * j / this.tileSize;
                Rectangle tileArea = new Rectangle(x, y, width, height);
                super.paint(g2d, tileArea, mapContext);
            }
        }
    }
}

