/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.wms.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;

public class WMSKvpRequestReaderAdapter
extends org.geoserver.ows.KvpRequestReader
implements HttpServletRequestAware {
    private KvpRequestReader delegate;
    Class<? extends KvpRequestReader> delegateClass;
    HttpServletRequest request;
    private WMS wms;

    public WMSKvpRequestReaderAdapter(Class requestBean, Class delegateClass, WMS wms) {
        super(requestBean);
        this.delegateClass = delegateClass;
        this.wms = wms;
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Object createRequest() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        Enumeration pnames = this.request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = this.request.getParameter(paramName);
            kvp.put(paramName.toUpperCase(), paramValue);
        }
        Constructor constructor = this.findConstructor();
        this.delegate = (KvpRequestReader)constructor.newInstance(kvp, this.wms);
        return this.delegate.getRequest(this.request);
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        Constructor constructor = this.findConstructor();
        this.delegate = (KvpRequestReader)constructor.newInstance(kvp, this.wms);
        return this.delegate.getRequest(this.request);
    }

    private Constructor findConstructor() {
        Class clazz = WMS.class;
        Constructor<? extends KvpRequestReader> constructor = null;
        while (clazz != null && constructor == null) {
            try {
                constructor = this.delegateClass.getConstructor(Map.class, clazz);
            }
            catch (NoSuchMethodException e) {
                Class<?>[] classes;
                for (Class<?> c : classes = clazz.getInterfaces()) {
                    try {
                        constructor = this.delegateClass.getConstructor(Map.class, c);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("No appropriate constructor");
        }
        return constructor;
    }
}

