/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public class ExtensionSet
extends DataType {
    private final ArrayList m_extensions = new ArrayList();
    private final ArrayList m_extensionsFilesets = new ArrayList();

    public void addExtension(ExtensionAdapter extensionAdapter) {
        this.m_extensions.add(extensionAdapter);
    }

    public void addLibfileset(LibFileSet fileSet) {
        this.m_extensionsFilesets.add(fileSet);
    }

    public void addFileset(FileSet fileSet) {
        this.m_extensionsFilesets.add(fileSet);
    }

    public Extension[] toExtensions(Project project) throws BuildException {
        ArrayList extensions = ExtensionUtil.toExtensions(this.m_extensions);
        ExtensionUtil.extractExtensions(project, extensions, this.m_extensionsFilesets);
        return extensions.toArray(new Extension[extensions.size()]);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.m_extensions.isEmpty() || !this.m_extensionsFilesets.isEmpty()) {
            throw this.tooManyAttributes();
        }
        Object object = reference.getReferencedObject(this.getProject());
        if (!(object instanceof ExtensionSet)) {
            String message = reference.getRefId() + " doesn't refer to a ExtensionSet";
            throw new BuildException(message);
        }
        ExtensionSet other = (ExtensionSet)((Object)object);
        this.m_extensions.addAll(other.m_extensions);
        this.m_extensionsFilesets.addAll(other.m_extensionsFilesets);
        super.setRefid(reference);
    }

    public String toString() {
        return "ExtensionSet" + Arrays.asList(this.toExtensions(this.getProject()));
    }
}

