/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.io.StringReader;
import java.util.List;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.commons.TokenAdapter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQLFilterBuilder;
import org.geotools.filter.text.generated.parsers.ECQLParser;
import org.geotools.filter.text.generated.parsers.Node;
import org.geotools.filter.text.generated.parsers.ParseException;
import org.geotools.filter.text.generated.parsers.TokenMgrError;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECQLCompiler
extends ECQLParser
implements ICompiler {
    private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
    private final String source;
    private final ECQLFilterBuilder builder;

    public ECQLCompiler(String txtSource, FilterFactory filterFactory) {
        super(new StringReader(txtSource));
        assert (txtSource != null) : "txtSource cannot be null";
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = txtSource;
        this.builder = new ECQLFilterBuilder(txtSource, filterFactory);
    }

    @Override
    public void compileFilter() throws CQLException {
        try {
            super.FilterCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileExpression() throws CQLException {
        try {
            super.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileFilterList() throws CQLException {
        try {
            super.FilterListCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    @Override
    public final Filter getFilter() throws CQLException {
        return this.builder.getFilter();
    }

    @Override
    public final Expression getExpression() throws CQLException {
        return this.builder.getExpression();
    }

    @Override
    public IToken getTokenInPosition(int index) {
        return TokenAdapter.newAdapterFor(super.getToken(index));
    }

    @Override
    public List<Filter> getFilterList() throws CQLException {
        return this.builder.getFilterList();
    }

    @Override
    public final void jjtreeOpenNodeScope(Node n) {
    }

    @Override
    public final void jjtreeCloseNodeScope(Node n) throws ParseException {
        try {
            Object built = this.build(n);
            IToken tokenAdapter = TokenAdapter.newAdapterFor(this.token);
            Result r = new Result(built, tokenAdapter, n.getType());
            this.builder.pushResult(r);
        }
        catch (CQLException e) {
            throw e;
        }
        finally {
            n.dispose();
        }
    }

    private Object build(Node n) throws CQLException {
        switch (n.getType()) {
            case 61: {
                return this.builder.buildLiteralInteger(((Object)this.getTokenInPosition(0)).toString());
            }
            case 62: {
                return this.builder.buildLiteralDouble(((Object)this.getTokenInPosition(0)).toString());
            }
            case 60: {
                return this.builder.bulidNegativeNumber();
            }
            case 65: {
                return this.builder.buildLiteralString(((Object)this.getTokenInPosition(0)).toString());
            }
            case 56: {
                return this.builder.buildIdentifier(57);
            }
            case 57: {
                return this.builder.buildIdentifierPart(this.getTokenInPosition(0));
            }
            case 58: {
                return this.builder.buildSimpleAttribute();
            }
            case 59: {
                return this.builder.buildCompoundAttribute(58, ATTRIBUTE_PATH_SEPARATOR);
            }
            case 66: {
                return this.builder.buildFunction(67);
            }
            case 67: {
                return n;
            }
            case 68: {
                return n;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return this.buildBinaryExpression(n.getType());
            }
            case 2: {
                return this.buildLogicFilter(2);
            }
            case 1: {
                return this.buildLogicFilter(1);
            }
            case 3: {
                return this.buildLogicFilter(3);
            }
            case 51: {
                return this.builder.buildBetween();
            }
            case 50: {
                return this.builder.buildNotBetween();
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this.buildBinaryComparasionOperator(n.getType());
            }
            case 33: {
                BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(28);
                Not notFilter = this.builder.buildNotFilter((Filter)eq);
                return notFilter;
            }
            case 49: {
                return this.builder.buildLikeFilter();
            }
            case 48: {
                return this.builder.buildNotLikeFilter();
            }
            case 34: {
                return this.builder.buildPropertyIsNull();
            }
            case 35: {
                return this.builder.buildPorpertyNotIsNull();
            }
            case 44: {
                return this.builder.buildDateTimeExpression(this.getTokenInPosition(0));
            }
            case 45: {
                return this.builder.buildDurationExpression(this.getTokenInPosition(0));
            }
            case 43: {
                return this.builder.buildPeriodBetweenDates();
            }
            case 42: {
                return this.builder.buildPeriodDateAndDuration();
            }
            case 41: {
                return this.builder.buildPeriodDurationAndDate();
            }
            case 36: {
                return this.buildTemporalPredicateBefore();
            }
            case 38: {
                return this.buildTemporalPredicateAfter();
            }
            case 39: {
                return this.buildTemporalPredicateDuring();
            }
            case 37: {
                return this.buildTemporalPredicateBeforeOrDuring();
            }
            case 40: {
                return this.buildTemporalPredicateDuringOrAfter();
            }
            case 46: {
                return this.builder.buildPropertyExists();
            }
            case 47: {
                PropertyIsEqualTo filter = this.builder.buildPropertyExists();
                Not filterPropNotExist = this.builder.buildNotFilter((Filter)filter);
                return filterPropNotExist;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.buildBinarySpatialOperator(n.getType());
            }
            case 19: 
            case 20: {
                return this.buildBBox(n.getType());
            }
            case 18: {
                return this.builder.buildRelate();
            }
            case 23: {
                return this.builder.buildTolerance();
            }
            case 24: {
                return this.builder.buildDistanceUnit(this.getTokenInPosition(0));
            }
            case 21: 
            case 22: {
                return this.buildDistanceBufferOperator(n.getType());
            }
            case 69: {
                return this.builder.buildCoordinate();
            }
            case 72: {
                return this.builder.buildPointText();
            }
            case 70: {
                return this.builder.buildLineString(69);
            }
            case 73: {
                return this.builder.buildPolygon(70);
            }
            case 74: {
                return this.builder.buildMultiPoint(72);
            }
            case 75: {
                return this.builder.buildMultiLineString(70);
            }
            case 76: {
                return this.builder.buildMultiPolygon(73);
            }
            case 25: {
                return this.builder.buildGeometryLiteral();
            }
            case 77: {
                return this.builder.buildGeometryCollection(25);
            }
            case 71: {
                return this.builder.buildGeometry();
            }
            case 78: {
                return this.builder.buildEnvelop(TokenAdapter.newAdapterFor(n.getToken()));
            }
            case 26: {
                return Filter.INCLUDE;
            }
            case 27: {
                return Filter.EXCLUDE;
            }
            case 63: {
                return this.builder.buildTrueLiteral();
            }
            case 64: {
                return this.builder.buildFalseLiteral();
            }
            case 6: {
                return this.builder.buildFeatureID(this.getTokenInPosition(0));
            }
            case 5: {
                return this.builder.buildFilterId(6);
            }
            case 4: {
                Id idFilter = this.builder.buildFilterId(6);
                Not notIdFilter = this.builder.buildNotFilter((Filter)idFilter);
                return notIdFilter;
            }
            case 8: {
                return this.builder.buildInPredicate(9);
            }
            case 7: {
                Or orFilter = this.builder.buildInPredicate(9);
                Not notOrFilter = this.builder.buildNotFilter((Filter)orFilter);
                return notOrFilter;
            }
        }
        return null;
    }

    private BinaryExpression buildBinaryExpression(int nodeType) throws CQLException {
        BinaryExpression expr = null;
        switch (nodeType) {
            case 52: {
                expr = this.builder.buildAddExpression();
                break;
            }
            case 53: {
                expr = this.builder.buildSubtractExression();
                break;
            }
            case 54: {
                expr = this.builder.buildMultiplyExpression();
                break;
            }
            case 55: {
                expr = this.builder.buildDivideExpression();
                break;
            }
        }
        return expr;
    }

    private Filter buildLogicFilter(int nodeType) throws CQLException {
        try {
            Filter logicFilter;
            switch (nodeType) {
                case 2: {
                    logicFilter = this.builder.buildAndFilter();
                    break;
                }
                case 1: {
                    logicFilter = this.builder.buildOrFilter();
                    break;
                }
                case 3: {
                    logicFilter = this.builder.buildNotFilter();
                    break;
                }
                default: {
                    throw new CQLException("Expression not supported. And, Or, Not is required", this.getTokenInPosition(0), this.source);
                }
            }
            return logicFilter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LogicFilter", this.getTokenInPosition(0), ife, this.source);
        }
    }

    private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws CQLException {
        BinarySpatialOperator filter = null;
        switch (nodeType) {
            case 10: {
                filter = this.builder.buildSpatialEqualFilter();
                break;
            }
            case 11: {
                filter = this.builder.buildSpatialDisjointFilter();
                break;
            }
            case 12: {
                filter = this.builder.buildSpatialIntersectsFilter();
                break;
            }
            case 13: {
                filter = this.builder.buildSpatialTouchesFilter();
                break;
            }
            case 14: {
                filter = this.builder.buildSpatialCrossesFilter();
                break;
            }
            case 15: {
                filter = this.builder.buildSpatialWithinFilter();
                break;
            }
            case 16: {
                filter = this.builder.buildSpatialContainsFilter();
                break;
            }
            case 17: {
                filter = this.builder.buildSpatialOverlapsFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private BBOX buildBBox(int nodeType) throws CQLException {
        if (nodeType == 20) {
            return this.builder.buildBBoxWithCRS();
        }
        return this.builder.buildBBox();
    }

    private DistanceBufferOperator buildDistanceBufferOperator(int nodeType) throws CQLException {
        DistanceBufferOperator filter = null;
        switch (nodeType) {
            case 21: {
                filter = this.builder.buildSpatialDWithinFilter();
                break;
            }
            case 22: {
                filter = this.builder.buildSpatialBeyondFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateBeforeOrDuring() throws CQLException {
        PropertyIsLessThanOrEqualTo filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 41: 
            case 42: 
            case 43: {
                filter = this.builder.buildPropertyIsLTELastDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateDuringOrAfter() throws CQLException {
        PropertyIsGreaterThanOrEqualTo filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 41: 
            case 42: 
            case 43: {
                filter = this.builder.buildPropertyIsGTEFirstDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateBefore() throws CQLException {
        BinaryComparisonOperator filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 44: {
                filter = this.buildBinaryComparasionOperator(30);
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                filter = this.builder.buildPropertyIsLTFirsDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Object buildTemporalPredicateDuring() throws CQLException {
        And filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 41: 
            case 42: 
            case 43: {
                filter = this.builder.buildPropertyBetweenDates();
                break;
            }
            default: {
                throw new CQLException("unexpeted period expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateAfter() throws CQLException {
        BinaryComparisonOperator filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 44: {
                filter = this.buildBinaryComparasionOperator(29);
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                filter = this.builder.buildPropertyIsGTLastDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws CQLException {
        switch (filterType) {
            case 28: {
                return this.builder.buildEquals();
            }
            case 29: {
                return this.builder.buildGreater();
            }
            case 30: {
                return this.builder.buildLess();
            }
            case 31: {
                return this.builder.buildGreaterOrEqual();
            }
            case 32: {
                return this.builder.buildLessOrEqual();
            }
        }
        throw new CQLException("unexpeted filter type.");
    }
}

