/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxFallbackLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.web.wicket.browser.FileProvider;

public abstract class FileDataView
extends Panel {
    private static final IConverter FILE_NAME_CONVERTER = new StringConverter(){

        public String convertToString(Object value, Locale locale) {
            File file = (File)value;
            if (file.isDirectory()) {
                return file.getName() + "/";
            }
            return file.getName();
        }
    };
    private static final IConverter FILE_LASTMODIFIED_CONVERTER = new StringConverter(){

        public String convertToString(Object value, Locale locale) {
            File file = (File)value;
            long lastModified = file.lastModified();
            if (lastModified == 0L) {
                return null;
            }
            return DateFormat.getDateTimeInstance(2, 3).format(new Date(file.lastModified()));
        }
    };
    private static final IConverter FILE_SIZE_CONVERTER = new StringConverter(){
        private static final double KBYTE = 1024.0;
        private static final double MBYTE = 1048576.0;
        private static final double GBYTE = 1.073741824E9;

        public String convertToString(Object value, Locale locale) {
            File file = (File)value;
            if (!file.isFile()) {
                return "";
            }
            long size = file.length();
            if (size == 0L) {
                return null;
            }
            if ((double)size < 1024.0) {
                return size + "";
            }
            if ((double)size < 1048576.0) {
                return new DecimalFormat("#.#").format((double)size / 1024.0) + "K";
            }
            if ((double)size < 1.073741824E9) {
                return new DecimalFormat("#.#").format((double)size / 1048576.0) + "M";
            }
            return new DecimalFormat("#.#").format((double)size / 1.073741824E9) + "G";
        }
    };
    FileProvider provider;

    public FileDataView(String id, FileProvider fileProvider) {
        super(id);
        this.provider = fileProvider;
        WebMarkupContainer table = new WebMarkupContainer("fileTable");
        table.setOutputMarkupId(true);
        this.add((Component)table);
        DataView fileTable = new DataView("files", (IDataProvider)fileProvider){

            protected void populateItem(final Item item) {
                File file = (File)item.getModelObject();
                item.add((IBehavior)new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd")));
                IndicatingAjaxFallbackLink link = new IndicatingAjaxFallbackLink("nameLink"){

                    public void onClick(AjaxRequestTarget target) {
                        FileDataView.this.linkNameClicked((File)item.getModelObject(), target);
                    }
                };
                link.add((Component)new Label("name", item.getModel()){

                    public IConverter getConverter(Class type) {
                        return FILE_NAME_CONVERTER;
                    }
                });
                item.add((Component)link);
                item.add((Component)new Label("lastModified", item.getModel()){

                    public IConverter getConverter(Class type) {
                        return FILE_LASTMODIFIED_CONVERTER;
                    }
                });
                item.add((Component)new Label("size", item.getModel()){

                    public IConverter getConverter(Class type) {
                        return FILE_SIZE_CONVERTER;
                    }
                });
            }
        };
        table.add((Component)fileTable);
        table.add((Component)new OrderByBorder("nameHeader", "name", (ISortStateLocator)fileProvider));
        table.add((Component)new OrderByBorder("lastModifiedHeader", "lastModified", (ISortStateLocator)fileProvider));
        table.add((Component)new OrderByBorder("sizeHeader", "size", (ISortStateLocator)fileProvider));
    }

    protected abstract void linkNameClicked(File var1, AjaxRequestTarget var2);

    public FileProvider getProvider() {
        return this.provider;
    }

    private static abstract class StringConverter
    implements IConverter {
        private StringConverter() {
        }

        public Object convertToObject(String value, Locale locale) {
            throw new UnsupportedOperationException("This converter works only for strings");
        }
    }
}

