/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class KeywordsEditor
extends FormComponentPanel {
    ListMultipleChoice choices;
    TextField newKeyword;

    public KeywordsEditor(String id, IModel keywords) {
        super(id, keywords);
        this.choices = new ListMultipleChoice("keywords", (IModel)new Model(), new ArrayList((List)keywords.getObject()));
        this.choices.setOutputMarkupId(true);
        this.add((Component)this.choices);
        this.add((Component)this.removeKeywordsButton());
        this.newKeyword = new TextField("newKeyword", (IModel)new Model());
        this.newKeyword.setOutputMarkupId(true);
        this.add((Component)this.newKeyword);
        this.add((Component)this.addKeywordsButton());
    }

    private AjaxButton addKeywordsButton() {
        AjaxButton button = new AjaxButton("addKeyword"){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                List choiceList = KeywordsEditor.this.choices.getChoices();
                choiceList.add(KeywordsEditor.this.newKeyword.getInput());
                KeywordsEditor.this.choices.setChoices(choiceList);
                KeywordsEditor.this.newKeyword.setModelObject(null);
                KeywordsEditor.this.newKeyword.modelChanged();
                target.addComponent((Component)KeywordsEditor.this.newKeyword);
                target.addComponent((Component)KeywordsEditor.this.choices);
            }
        };
        button.setDefaultFormProcessing(false);
        return button;
    }

    private AjaxButton removeKeywordsButton() {
        AjaxButton button = new AjaxButton("removeKeywords"){

            public void onSubmit(AjaxRequestTarget target, Form form) {
                List selection = (List)KeywordsEditor.this.choices.getModelObject();
                List keywords = KeywordsEditor.this.choices.getChoices();
                for (String selected : selection) {
                    keywords.remove(selected);
                }
                KeywordsEditor.this.choices.setChoices(keywords);
                KeywordsEditor.this.choices.modelChanged();
                target.addComponent((Component)KeywordsEditor.this.choices);
            }
        };
        return button;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.updateFields();
    }

    private void updateFields() {
        this.choices.setChoices(this.getModel());
    }

    protected void convertInput() {
        this.setConvertedInput(this.choices.getChoices());
    }
}

