/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.wicket.URIValidator;
import org.geoserver.web.wicket.XMLNameValidator;

public class WorkspaceNewPage
extends GeoServerSecuredPage {
    Form form;
    TextField nsUriTextField;
    boolean defaultWs;

    public WorkspaceNewPage() {
        WorkspaceInfo ws = this.getCatalog().getFactory().createWorkspace();
        this.form = new Form("form", (IModel)new CompoundPropertyModel((Object)ws)){

            protected void onSubmit() {
                Catalog catalog = WorkspaceNewPage.this.getCatalog();
                WorkspaceInfo ws = (WorkspaceInfo)WorkspaceNewPage.this.form.getModelObject();
                NamespaceInfo ns = catalog.getFactory().createNamespace();
                ns.setPrefix(ws.getName());
                ns.setURI(WorkspaceNewPage.this.nsUriTextField.getModelObjectAsString());
                catalog.add(ws);
                catalog.add(ns);
                if (WorkspaceNewPage.this.defaultWs) {
                    catalog.setDefaultWorkspace(ws);
                }
                this.setResponsePage(WorkspacePage.class);
            }
        };
        this.add((Component)this.form);
        TextField nameTextField = new TextField("name");
        nameTextField.setRequired(true);
        nameTextField.add((IValidator)new XMLNameValidator());
        this.form.add((Component)nameTextField.setRequired(true));
        this.nsUriTextField = new TextField("uri", (IModel)new Model());
        this.nsUriTextField.setRequired(true);
        this.nsUriTextField.add((IValidator)new URIValidator());
        this.form.add((Component)this.nsUriTextField);
        CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
        this.form.add((Component)defaultChk);
        SubmitLink submitLink = new SubmitLink("submit", this.form);
        this.form.add((Component)submitLink);
        this.form.setDefaultButton((IFormSubmittingComponent)submitLink);
        AjaxLink cancelLink = new AjaxLink("cancel"){

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage(WorkspacePage.class);
            }
        };
        this.form.add((Component)cancelLink);
    }
}

