/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.util.logging.Level;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geotools.data.DataAccess;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

public class DataAccessNewPage
extends AbstractDataAccessPage {
    private static final long serialVersionUID = 1L;

    public DataAccessNewPage(String dataStoreFactDisplayName) {
        WorkspaceInfo defaultWs = this.getCatalog().getDefaultWorkspace();
        if (defaultWs == null) {
            throw new IllegalStateException("No default Workspace configured");
        }
        NamespaceInfo defaultNs = this.getCatalog().getDefaultNamespace();
        if (defaultNs == null) {
            throw new IllegalStateException("No default Namespace configured");
        }
        DataStoreInfo info = this.getCatalog().getFactory().createDataStore();
        info.setWorkspace(defaultWs);
        info.setEnabled(true);
        info.setType(dataStoreFactDisplayName);
        this.initUI(info);
    }

    protected final void onSaveDataStore(DataStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        NewLayerPage newLayerPage;
        Catalog catalog = this.getCatalog();
        try {
            DataAccess dataStore = info.getDataStore((ProgressListener)new NullProgressListener());
            dataStore.dispose();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error obtaining new data store", e);
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            throw new IllegalArgumentException("Error creating data store, check the parameters. Error message: " + message);
        }
        DataStoreInfo savedStore = catalog.getFactory().createDataStore();
        this.clone(info, savedStore);
        try {
            catalog.add((StoreInfo)savedStore);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error adding data store to catalog", e);
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            throw new IllegalArgumentException("Error creating data store with the provided parameters: " + message);
        }
        try {
            newLayerPage = new NewLayerPage(savedStore.getId());
        }
        catch (RuntimeException e) {
            try {
                catalog.remove((StoreInfo)savedStore);
            }
            catch (Exception removeEx) {
                LOGGER.log(Level.WARNING, "Error removing just added datastore!", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.setResponsePage((Page)newLayerPage);
    }
}

