/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.opengis.feature.type.PropertyDescriptor;

public class FeatureResourceConfigurationPanel
extends ResourceConfigurationPanel {
    ModalWindow reloadWarningDialog;

    public FeatureResourceConfigurationPanel(String id, final IModel model) {
        super(id, model);
        final Fragment attributePanel = new Fragment("attributePanel", "attributePanelFragment", (MarkupContainer)this);
        attributePanel.setOutputMarkupId(true);
        this.add((Component)attributePanel);
        ListView attributes = new ListView("attributes", (IModel)new Model(){

            public Object getObject() {
                FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                try {
                    return typeInfo.attributes();
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        }){

            protected void populateItem(ListItem item) {
                item.add((IBehavior)new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd")));
                AttributeTypeInfo attribute = (AttributeTypeInfo)item.getModelObject();
                item.add((Component)new Label("name", attribute.getName()));
                item.add((Component)new Label("minmax", attribute.getMinOccurs() + "/" + attribute.getMaxOccurs()));
                try {
                    FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
                    PropertyDescriptor pd = typeInfo.getFeatureType().getDescriptor(attribute.getName());
                    String typeName = pd.getType().getBinding().getSimpleName();
                    item.add((Component)new Label("type", typeName));
                    item.add((Component)new Label("nillable", pd.isNillable() + ""));
                }
                catch (IOException e) {
                    item.add((Component)new Label("type", "?"));
                    item.add((Component)new Label("nillable", "?"));
                }
            }
        };
        attributePanel.add((Component)attributes);
        GeoServerAjaxFormLink reload = new GeoServerAjaxFormLink("reload"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                GeoServerApplication app = (GeoServerApplication)this.getApplication();
                FeatureTypeInfo ft = (FeatureTypeInfo)FeatureResourceConfigurationPanel.this.getResourceInfo();
                app.getCatalog().getResourcePool().clear(ft);
                app.getCatalog().getResourcePool().clear(ft.getStore());
                target.addComponent((Component)attributePanel);
            }
        };
        attributePanel.add((Component)reload);
        GeoServerAjaxFormLink warning = new GeoServerAjaxFormLink("reloadWarning"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                FeatureResourceConfigurationPanel.this.reloadWarningDialog.show(target);
            }
        };
        attributePanel.add((Component)warning);
        this.reloadWarningDialog = new ModalWindow("reloadWarningDialog");
        this.add((Component)this.reloadWarningDialog);
        this.reloadWarningDialog.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new ReloadWarningDialog(new StringResourceModel("featureTypeReloadWarning", (Component)FeatureResourceConfigurationPanel.this, null));
            }
        });
        this.reloadWarningDialog.setTitle((IModel)new StringResourceModel("warning", (Component)null, null));
        this.reloadWarningDialog.setInitialHeight(100);
        this.reloadWarningDialog.setInitialHeight(200);
    }

    static class ReloadWarningDialog
    extends WebPage {
        public ReloadWarningDialog(StringResourceModel message) {
            this.add((Component)new Label("message", (IModel)message));
        }
    }
}

