/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.HashMap;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.NewDataPage;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geotools.util.Version;

public class GeoServerHomePage
extends GeoServerBasePage {
    public GeoServerHomePage() {
        GeoServer gs = this.getGeoServer();
        ContactInfo contact = gs.getGlobal().getContact();
        this.add((Component)new ExternalLink("contactURL", contact.getOnlineResource()).add((Component)new Label("contactName", contact.getContactOrganization())));
        String version = String.valueOf(new ResourceModel("version").getObject());
        String contactEmail = contact.getContactEmail();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        params.put("contactEmail", contactEmail);
        Label label = new Label("footerMessage", (IModel)new StringResourceModel("GeoServerHomePage.footer", (Component)this, (IModel)new Model(params)));
        label.setEscapeModelStrings(false);
        this.add((Component)label);
        Authentication auth = this.getSession().getAuthentication();
        if (this.isAdmin(auth)) {
            Fragment f = new Fragment("catalogLinks", "catalogLinksFragment", (MarkupContainer)this);
            Catalog catalog = this.getCatalog();
            f.add((Component)new BookmarkablePageLink("layersLink", LayerPage.class).add((Component)new Label("nlayers", "" + catalog.getLayers().size())));
            f.add((Component)new BookmarkablePageLink("addLayerLink", NewLayerPage.class));
            f.add((Component)new BookmarkablePageLink("storesLink", StorePage.class).add((Component)new Label("nstores", "" + catalog.getStores(StoreInfo.class).size())));
            f.add((Component)new BookmarkablePageLink("addStoreLink", NewDataPage.class));
            f.add((Component)new BookmarkablePageLink("workspacesLink", WorkspacePage.class).add((Component)new Label("nworkspaces", "" + catalog.getWorkspaces().size())));
            f.add((Component)new BookmarkablePageLink("addWorkspaceLink", WorkspaceNewPage.class));
            this.add((Component)f);
        } else {
            Label placeHolder = new Label("catalogLinks");
            placeHolder.setVisible(false);
            this.add((Component)placeHolder);
        }
        ListView view = new ListView("services", this.getServices()){

            protected void populateItem(ListItem item) {
                ServiceInfo service = (ServiceInfo)item.getModelObject();
                final String serviceId = service.getId();
                item.add((Component)new Label("service", service.getId().toUpperCase()));
                item.add((Component)new ListView("versions", service.getVersions()){

                    protected void populateItem(ListItem item) {
                        Version version = (Version)item.getModelObject();
                        ExternalLink link = new ExternalLink("link", "../ows?service=" + serviceId + "&version=" + version.toString() + "&request=GetCapabilities");
                        item.add((Component)link);
                        link.add((Component)new Label("version", version.toString()));
                    }
                });
            }
        };
        this.add((Component)view);
    }

    private boolean isAdmin(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!"ROLE_ADMINISTRATOR".equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    private IModel getServices() {
        return new LoadableDetachableModel(){

            protected Object load() {
                return GeoServerHomePage.this.getGeoServerApplication().getGeoServer().getServices();
            }
        };
    }
}

