/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.message.Trace;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;

public class PageInputStream
extends InputStream {
    private PageStore store;
    private final Trace trace;
    private int trunkNext;
    private int dataPage;
    private PageStreamTrunk trunk;
    private PageStreamData data;
    private boolean endOfFile;
    private int remaining;
    private byte[] buffer = new byte[1];
    private int logKey;

    PageInputStream(PageStore pageStore, int n, int n2, int n3) {
        this.store = pageStore;
        this.trace = pageStore.getTrace();
        this.logKey = n - 1;
        this.trunkNext = n2;
        this.dataPage = n3;
    }

    public int read() throws IOException {
        int n = this.read(this.buffer);
        return n < 0 ? -1 : this.buffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
            n4 += n3;
            n += n3;
            n2 -= n3;
        }
        return n4 == 0 ? -1 : n4;
    }

    private int readBlock(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.data.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new EOFException();
        }
    }

    private void fillBuffer() throws SQLException, EOFException {
        int n;
        if (this.remaining > 0 || this.endOfFile) {
            return;
        }
        if (this.trunkNext == 0) {
            this.endOfFile = true;
            return;
        }
        while (true) {
            if (this.trunk == null) {
                this.trunk = (PageStreamTrunk)this.store.getPage(this.trunkNext);
                ++this.logKey;
                if (this.trunk == null) {
                    throw new EOFException();
                }
                if (this.trunk.getLogKey() != this.logKey) {
                    throw new EOFException();
                }
                this.trunk.resetIndex();
                this.trunkNext = this.trunk.getNextTrunk();
            }
            if (this.trunk == null) continue;
            n = this.trunk.getNextPageData();
            if (n == -1) {
                this.trunk = null;
                continue;
            }
            if (this.dataPage == -1 || this.dataPage == n) break;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageIn.readPage " + n);
        }
        this.dataPage = -1;
        this.data = (PageStreamData)this.store.getPage(n);
        if (this.data == null) {
            throw new EOFException();
        }
        if (this.data.getLogKey() != this.logKey) {
            throw new EOFException();
        }
        this.data.initRead();
        this.remaining = this.data.getRemaining();
    }

    BitField allocateAllPages() throws SQLException {
        BitField bitField = new BitField();
        int n = this.trunkNext;
        while (n != 0) {
            int n2;
            bitField.set(n);
            this.store.allocatePage(n);
            PageStreamTrunk pageStreamTrunk = (PageStreamTrunk)this.store.getPage(n);
            if (pageStreamTrunk == null) break;
            pageStreamTrunk.resetIndex();
            while ((n2 = pageStreamTrunk.getNextPageData()) != -1) {
                bitField.set(n2);
                this.store.allocatePage(n2);
            }
            n = pageStreamTrunk.getNextTrunk();
        }
        return bitField;
    }

    int getDataPage() {
        return this.data.getPos();
    }

    public void close() {
    }
}

