/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCursor
implements Cursor {
    private Session session;
    private Index index;
    private Table table;
    private IndexColumn[] indexColumns;
    private boolean alwaysFalse;
    private SearchRow start;
    private SearchRow end;
    private Cursor cursor;
    private Column inColumn;
    private int inListIndex;
    private Value[] inList;
    private LocalResult inResult;
    private HashSet<Value> inResultTested;

    public void setIndex(Index index) {
        this.index = index;
        this.table = index.getTable();
        Column[] columnArray = this.table.getColumns();
        this.indexColumns = new IndexColumn[columnArray.length];
        IndexColumn[] indexColumnArray = index.getIndexColumns();
        if (indexColumnArray != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                int n = index.getColumnIndex(columnArray[i]);
                if (n < 0) continue;
                this.indexColumns[i] = indexColumnArray[n];
            }
        }
    }

    public void find(Session session, ObjectArray<IndexCondition> objectArray) throws SQLException {
        this.session = session;
        this.alwaysFalse = false;
        this.end = null;
        this.start = null;
        this.inList = null;
        this.inResult = null;
        this.inResultTested = new HashSet();
        for (IndexCondition indexCondition : objectArray) {
            if (indexCondition.isAlwaysFalse()) {
                this.alwaysFalse = true;
                break;
            }
            Column column = indexCondition.getColumn();
            int n = column.getType();
            int n2 = column.getColumnId();
            if (indexCondition.getCompareType() == 9) {
                this.inColumn = column;
                this.inList = indexCondition.getCurrentValueList(session);
                this.inListIndex = 0;
                return;
            }
            if (indexCondition.getCompareType() == 10) {
                this.inColumn = column;
                this.inResult = indexCondition.getCurrentResult(session);
                return;
            }
            Value value = indexCondition.getCurrentValue(session).convertTo(n);
            boolean bl = indexCondition.isStart();
            boolean bl2 = indexCondition.isEnd();
            IndexColumn indexColumn = this.indexColumns[n2];
            if (indexColumn != null && (indexColumn.sortType & 1) != 0) {
                boolean bl3 = bl;
                bl = bl2;
                bl2 = bl3;
            }
            if (bl) {
                this.start = this.getSearchRow(this.start, n2, value, true);
            }
            if (!bl2) continue;
            this.end = this.getSearchRow(this.end, n2, value, false);
        }
        if (!this.alwaysFalse) {
            this.cursor = this.index.find(session, this.start, this.end);
        }
    }

    private SearchRow getSearchRow(SearchRow searchRow, int n, Value value, boolean bl) throws SQLException {
        if (searchRow == null) {
            searchRow = this.table.getTemplateRow();
        } else {
            value = this.getMax(searchRow.getValue(n), value, bl);
        }
        searchRow.setValue(n, value);
        return searchRow;
    }

    private Value getMax(Value value, Value value2, boolean bl) throws SQLException {
        if (value == null) {
            return value2;
        }
        if (value2 == null) {
            return value;
        }
        int n = value.compareTo(value2, this.table.getDatabase().getCompareMode());
        if (!bl) {
            n = -n;
        }
        return n > 0 ? value : value2;
    }

    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    @Override
    public Row get() throws SQLException {
        return this.cursor.get();
    }

    @Override
    public long getKey() {
        return this.cursor.getKey();
    }

    @Override
    public SearchRow getSearchRow() throws SQLException {
        return this.cursor.getSearchRow();
    }

    @Override
    public boolean next() throws SQLException {
        while (true) {
            if (this.cursor == null) {
                this.nextCursor();
                if (this.cursor == null) {
                    return false;
                }
            }
            if (this.cursor.next()) {
                return true;
            }
            this.cursor = null;
        }
    }

    private void nextCursor() throws SQLException {
        block3: {
            block2: {
                if (this.inList == null) break block2;
                if (this.inListIndex >= this.inList.length) break block3;
                Value value = this.inList[this.inListIndex++];
                this.find(value);
                break block3;
            }
            if (this.inResult != null) {
                while (this.inResult.next()) {
                    Value value = this.inResult.currentRow()[0];
                    if (!this.inResultTested.add(value = value.convertTo(this.inColumn.getType()))) continue;
                    this.find(value);
                    break;
                }
            }
        }
    }

    private void find(Value value) throws SQLException {
        value = value.convertTo(this.inColumn.getType());
        int n = this.inColumn.getColumnId();
        if (this.start == null) {
            this.start = this.table.getTemplateRow();
        }
        this.start.setValue(n, value);
        this.cursor = this.index.find(this.session, this.start, this.start);
    }

    @Override
    public boolean previous() {
        throw Message.throwInternalError();
    }
}

