/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MapContext {
    public boolean addLayer(MapLayer var1);

    public boolean addLayer(int var1, MapLayer var2);

    public void addLayer(FeatureSource<SimpleFeatureType, SimpleFeature> var1, Style var2);

    public void addLayer(FeatureCollection<SimpleFeatureType, SimpleFeature> var1, Style var2);

    public void addLayer(Collection var1, Style var2);

    public void addLayer(GridCoverage var1, Style var2);

    public void addLayer(AbstractGridCoverage2DReader var1, Style var2);

    public boolean removeLayer(MapLayer var1);

    public MapLayer removeLayer(int var1);

    public int addLayers(MapLayer[] var1);

    public void removeLayers(MapLayer[] var1);

    public void clearLayerList();

    public MapLayer[] getLayers();

    public MapLayer getLayer(int var1) throws IndexOutOfBoundsException;

    public void moveLayer(int var1, int var2);

    public Iterator iterator();

    public int indexOf(MapLayer var1);

    public int getLayerCount();

    public ReferencedEnvelope getLayerBounds() throws IOException;

    public void addMapLayerListListener(MapLayerListListener var1);

    public void removeMapLayerListListener(MapLayerListListener var1);

    public void setAreaOfInterest(Envelope var1) throws IllegalArgumentException;

    public void setAreaOfInterest(Envelope var1, CoordinateReferenceSystem var2) throws IllegalArgumentException;

    public void setAreaOfInterest(ReferencedEnvelope var1) throws IllegalArgumentException;

    public ReferencedEnvelope getAreaOfInterest();

    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public void transform(AffineTransform var1);

    public void addMapBoundsListener(MapBoundsListener var1);

    public void removeMapBoundsListener(MapBoundsListener var1);

    public String getAbstract();

    public void setAbstract(String var1);

    public String getContactInformation();

    public void setContactInformation(String var1);

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem var1) throws TransformException, FactoryException;

    public String[] getKeywords();

    public void setKeywords(String[] var1);

    public String getTitle();

    public void setTitle(String var1);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);
}

