/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HttpSessionContextIntegrationFilter
implements InitializingBean,
Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$context$HttpSessionContextIntegrationFilter == null ? (class$org$acegisecurity$context$HttpSessionContextIntegrationFilter = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.HttpSessionContextIntegrationFilter")) : class$org$acegisecurity$context$HttpSessionContextIntegrationFilter));
    static final String FILTER_APPLIED = "__acegi_session_integration_filter_applied";
    public static final String ACEGI_SECURITY_CONTEXT_KEY = "ACEGI_SECURITY_CONTEXT";
    private Class context = class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl;
    private Object contextObject = this.generateNewContext();
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    private boolean cloneFromHttpSession = false;
    static /* synthetic */ Class class$org$acegisecurity$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContextImpl;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContext;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$java$lang$Cloneable;

    public boolean isCloneFromHttpSession() {
        return this.cloneFromHttpSession;
    }

    public void setCloneFromHttpSession(boolean cloneFromHttpSession) {
        this.cloneFromHttpSession = cloneFromHttpSession;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.context == null || !(class$org$acegisecurity$context$SecurityContext == null ? (class$org$acegisecurity$context$SecurityContext = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.SecurityContext")) : class$org$acegisecurity$context$SecurityContext).isAssignableFrom(this.context)) {
            throw new IllegalArgumentException("context must be defined and implement SecurityContext (typically use org.acegisecurity.context.SecurityContextImpl; existing class is " + this.context + ")");
        }
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = HttpSessionContextIntegrationFilter.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest), (Object)req, (String)"ServletRequest must be an instance of HttpServletRequest");
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = HttpSessionContextIntegrationFilter.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse), (Object)res, (String)"ServletResponse must be an instance of HttpServletResponse");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession httpSession = null;
        try {
            httpSession = request.getSession(this.forceEagerSessionCreation);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        boolean httpSessionExistedAtStartOfRequest = httpSession != null;
        SecurityContext contextBeforeChainExecution = this.readSecurityContextFromSession(httpSession);
        httpSession = null;
        if (contextBeforeChainExecution == null) {
            contextBeforeChainExecution = this.generateNewContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New SecurityContext instance will be associated with SecurityContextHolder");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Obtained a valid SecurityContext from ACEGI_SECURITY_CONTEXT to associate with SecurityContextHolder: '" + contextBeforeChainExecution + "'"));
        }
        int contextHashBeforeChainExecution = contextBeforeChainExecution.hashCode();
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        OnRedirectUpdateSessionResponseWrapper responseWrapper = new OnRedirectUpdateSessionResponseWrapper(response, request, httpSessionExistedAtStartOfRequest, contextHashBeforeChainExecution);
        try {
            SecurityContextHolder.setContext(contextBeforeChainExecution);
            chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
        }
        finally {
            SecurityContext contextAfterChainExecution = SecurityContextHolder.getContext();
            SecurityContextHolder.clearContext();
            request.removeAttribute(FILTER_APPLIED);
            if (!responseWrapper.isSessionUpdateDone()) {
                this.storeSecurityContextInSession(contextAfterChainExecution, request, httpSessionExistedAtStartOfRequest, contextHashBeforeChainExecution);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SecurityContextHolder now cleared, as request processing completed");
            }
        }
    }

    private SecurityContext readSecurityContextFromSession(HttpSession httpSession) {
        if (httpSession == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No HttpSession currently exists");
            }
            return null;
        }
        Object contextFromSessionObject = httpSession.getAttribute(ACEGI_SECURITY_CONTEXT_KEY);
        if (contextFromSessionObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"HttpSession returned null object for ACEGI_SECURITY_CONTEXT");
            }
            return null;
        }
        if (this.cloneFromHttpSession) {
            Assert.isInstanceOf((Class)(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = HttpSessionContextIntegrationFilter.class$("java.lang.Cloneable")) : class$java$lang$Cloneable), (Object)contextFromSessionObject, (String)"Context must implement Clonable and provide a Object.clone() method");
            try {
                Method m = contextFromSessionObject.getClass().getMethod("clone", new Class[0]);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                contextFromSessionObject = m.invoke(contextFromSessionObject, new Object[0]);
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
        if (!(contextFromSessionObject instanceof SecurityContext)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("ACEGI_SECURITY_CONTEXT did not contain a SecurityContext but contained: '" + contextFromSessionObject + "'; are you improperly modifying the HttpSession directly " + "(you should always use SecurityContextHolder) or using the HttpSession attribute " + "reserved for this class?"));
            }
            return null;
        }
        return (SecurityContext)contextFromSessionObject;
    }

    private void storeSecurityContextInSession(SecurityContext securityContext, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest, int contextHashBeforeChainExecution) {
        HttpSession httpSession = null;
        try {
            httpSession = request.getSession(false);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        if (httpSession == null) {
            if (httpSessionExistedAtStartOfRequest) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
            } else if (!this.allowSessionCreation) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The HttpSession is currently null, and the HttpSessionContextIntegrationFilter is prohibited from creating an HttpSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                }
            } else if (!this.contextObject.equals(securityContext)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession being created as SecurityContextHolder contents are non-default");
                }
                try {
                    httpSession = request.getSession(true);
                }
                catch (IllegalStateException ignored) {}
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("HttpSession is null, but SecurityContextHolder has not changed from default: ' " + securityContext + "'; not creating HttpSession or storing SecurityContextHolder contents"));
            }
        }
        if (httpSession != null && securityContext.hashCode() != contextHashBeforeChainExecution) {
            httpSession.setAttribute(ACEGI_SECURITY_CONTEXT_KEY, (Object)securityContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContext stored to HttpSession: '" + securityContext + "'"));
            }
        }
    }

    public SecurityContext generateNewContext() throws ServletException {
        try {
            return (SecurityContext)this.context.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ServletException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException((Throwable)iae);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public Class getContext() {
        return this.context;
    }

    public void setContext(Class secureContext) {
        this.context = secureContext;
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OnRedirectUpdateSessionResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletRequest request;
        boolean httpSessionExistedAtStartOfRequest;
        int contextHashBeforeChainExecution;
        boolean sessionUpdateDone = false;

        public OnRedirectUpdateSessionResponseWrapper(HttpServletResponse response, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest, int contextHashBeforeChainExecution) {
            super(response);
            this.request = request;
            this.httpSessionExistedAtStartOfRequest = httpSessionExistedAtStartOfRequest;
            this.contextHashBeforeChainExecution = contextHashBeforeChainExecution;
        }

        public void sendError(int sc) throws IOException {
            this.doSessionUpdate();
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.doSessionUpdate();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.doSessionUpdate();
            super.sendRedirect(location);
        }

        private void doSessionUpdate() {
            if (this.sessionUpdateDone) {
                return;
            }
            SecurityContext securityContext = SecurityContextHolder.getContext();
            HttpSessionContextIntegrationFilter.this.storeSecurityContextInSession(securityContext, this.request, this.httpSessionExistedAtStartOfRequest, this.contextHashBeforeChainExecution);
            this.sessionUpdateDone = true;
        }

        public boolean isSessionUpdateDone() {
            return this.sessionUpdateDone;
        }
    }
}

