/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.schema.impl;

import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.AttributeValueGT;
import org.geotools.xml.schema.impl.ElementValueGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleTypeGT
implements SimpleType {
    private int finaL;
    private String id;
    private String name;
    private URI namespace;
    private SimpleType[] parents = null;
    private int type = 0;
    private Facet[] constraints;

    private SimpleTypeGT() {
    }

    public SimpleTypeGT(String id, String name, URI namespace, int type, SimpleType[] parents, Facet[] constraints, int finaL) {
        this.id = id;
        this.name = name;
        this.namespace = namespace;
        this.parents = parents;
        this.type = type;
        this.constraints = constraints;
        if (constraints != null) {
            for (int i = 0; i < constraints.length; ++i) {
                if (constraints[i] != null) continue;
                throw new NullPointerException(name + " constraint #" + i + " is null");
            }
        }
    }

    public Class getInstanceType() {
        return this.parents[0].getInstanceType();
    }

    public Element findChildElement(String name1) {
        return null;
    }

    public int getFinal() {
        return this.finaL;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public SimpleType[] getParents() {
        return this.parents;
    }

    public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
        if (value == null || value.length != 1) {
            throw new SAXException("can only have one text value ... and one is required");
        }
        if (this.type == 1) {
            return this.getUnionValue(element, value[0], attrs, hints);
        }
        if (this.type == 2) {
            return this.getListValue(element, value[0], attrs, hints);
        }
        return this.getRestValue(element, value[0], attrs, hints);
    }

    private Object getUnionValue(Element element, ElementValue value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null) {
            return null;
        }
        ElementValue[] valss = new ElementValue[]{value};
        for (int i = 0; i < this.parents.length; ++i) {
            Object o = this.parents[0].getValue(element, valss, attrs, hints);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private Object getListValue(Element element, ElementValue value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null || this.parents[0] == null) {
            return null;
        }
        String[] vals = ((String)value.getValue()).split("\\s");
        LinkedList<Object> l = new LinkedList<Object>();
        ElementValue[] valss = new ElementValueGT[1];
        for (int i = 0; i < vals.length; ++i) {
            valss[0] = new ElementValueGT(value.getElement(), vals[i]);
            l.add(this.parents[0].getValue(element, valss, attrs, hints));
        }
        valss[0] = new ElementValueGT(value.getElement(), l);
        return valss[0];
    }

    private Object getRestValue(Element element, ElementValue value, Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null || this.parents[0] == null) {
            return null;
        }
        if (this.constraints == null) {
            return null;
        }
        if (this.constraints.length == 0) {
            ElementValue[] t = new ElementValue[]{value};
            return this.parents[0].getValue(element, t, attrs, hints);
        }
        String val = (String)value.getValue();
        if (val != null && this.constraints[0].getFacetType() == 1) {
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!val.equalsIgnoreCase(this.constraints[i].getValue())) continue;
                ElementValue[] t = new ElementValue[]{value};
                return this.parents[0].getValue(element, t, attrs, hints);
            }
            return null;
        }
        Number nval = null;
        Date dval = null;
        ElementValue[] t = new ElementValue[]{value};
        Object o = this.parents[0].getValue(element, t, attrs, hints);
        if (o instanceof Number) {
            nval = (Number)o;
        }
        if (o instanceof Date) {
            dval = (Date)o;
        }
        block22: for (int i = 0; i < this.constraints.length; ++i) {
            switch (this.constraints[i].getFacetType()) {
                case 1: {
                    continue block22;
                }
                case 2: {
                    int decimals = val.length() - val.indexOf(".");
                    int maxDec = Integer.parseInt(this.constraints[i].getValue());
                    if (decimals <= maxDec) continue block22;
                    throw new SAXException("Too many decimal places");
                }
                case 3: {
                    int maxLength = Integer.parseInt(this.constraints[i].getValue());
                    if (val.length() == maxLength) continue block22;
                    throw new SAXException("Too long places");
                }
                case 4: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(this.constraints[i].getValue());
                        if (nval.doubleValue() > max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval == null) continue block22;
                    try {
                        max = DateFormat.getDateTimeInstance().parse(this.constraints[i].getValue());
                    }
                    catch (ParseException e) {
                        throw new SAXException(e);
                    }
                    if (!dval.after((Date)max)) continue block22;
                    throw new SAXException("Too large a value");
                }
                case 5: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(this.constraints[i].getValue());
                        if (nval.doubleValue() >= max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(this.constraints[i].getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.compareTo((Date)max) > 0) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 6: {
                    int maxLength = Integer.parseInt(this.constraints[i].getValue());
                    if (val.length() <= maxLength) continue block22;
                    throw new SAXException("Too long places");
                }
                case 7: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(this.constraints[i].getValue());
                        if (nval.doubleValue() < max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(this.constraints[i].getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.before((Date)max)) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 8: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(this.constraints[i].getValue());
                        if (nval.doubleValue() <= max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(this.constraints[i].getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.compareTo((Date)max) < 0) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 9: {
                    int maxLength = Integer.parseInt(this.constraints[i].getValue());
                    if (val.length() >= maxLength) continue block22;
                    throw new SAXException("Too short places");
                }
                case 10: {
                    if (val.split(this.constraints[i].getValue()).length == 1) continue block22;
                    throw new SAXException("Does not match pattern");
                }
                case 11: {
                    int maxLength = Integer.parseInt(this.constraints[i].getValue()) + 1;
                    if (val.length() <= maxLength) continue block22;
                    throw new SAXException("Too many digits");
                }
            }
        }
        return o;
    }

    public int getChildType() {
        return this.type;
    }

    public Facet[] getFacets() {
        return this.constraints;
    }

    public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) throws OperationNotSupportedException {
        if (value == null) {
            return null;
        }
        if (this.type == 1) {
            for (int i = 0; i < this.parents.length; ++i) {
                if (!this.parents[i].equals(attribute.getSimpleType()) || !this.parents[i].canCreateAttributes(attribute, value, hints)) continue;
                return this.parents[i].toAttribute(attribute, value, hints);
            }
            return this.parents[0].toAttribute(attribute, value, hints);
        }
        if (this.type == 2) {
            List l = (List)value;
            Iterator i = l.iterator();
            String s = "";
            if (i.hasNext()) {
                String t = this.parents[0].toAttribute(attribute, i.next(), hints).getValue();
                s = t.toString();
                while (i.hasNext()) {
                    t = this.parents[0].toAttribute(attribute, i.next(), hints).getValue();
                    s = s + " " + t.toString();
                }
            }
            return new AttributeValueGT(attribute, s);
        }
        return this.parents[0].toAttribute(attribute, value, hints);
    }

    public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
        if (value == null) {
            return false;
        }
        if (this.type == 1) {
            for (int i = 0; i < this.parents.length; ++i) {
                if (!this.parents[i].equals(attribute.getSimpleType()) || !this.parents[i].canCreateAttributes(attribute, value, hints)) continue;
                return true;
            }
            return false;
        }
        if (this.type == 2) {
            return this.parents[0].canCreateAttributes(attribute, value, hints);
        }
        return this.parents[0].canCreateAttributes(attribute, value, hints);
    }

    public boolean canEncode(Element element, Object value, Map hints) {
        if (value == null) {
            return false;
        }
        if (this.type == 1) {
            for (int i = 0; i < this.parents.length; ++i) {
                if (!this.parents[i].equals(element.getType()) || !this.parents[i].canEncode(element, value, hints)) continue;
                return true;
            }
            return false;
        }
        if (this.type == 2) {
            return this.parents[0].canEncode(element, value, hints);
        }
        return this.parents[0].canEncode(element, value, hints);
    }

    public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
        if (value == null) {
            return;
        }
        if (this.type == 1) {
            int i = 0;
            if (i < this.parents.length) {
                if (this.parents[i].equals(element.getType()) && this.parents[i].canEncode(element, value, hints)) {
                    this.parents[i].encode(element, value, output, hints);
                }
                return;
            }
            this.parents[0].encode(element, value, output, hints);
            return;
        }
        if (this.type == 2) {
            List l = (List)value;
            Iterator i = l.iterator();
            String s = "";
            if (i.hasNext()) {
                String t = this.parents[0].toAttribute(new AttributeGT(null, null, this.namespace, this.parents[0], 0, null, null, false), value, hints).getValue();
                s = t.toString();
                while (i.hasNext()) {
                    t = this.parents[0].toAttribute(new AttributeGT(null, null, this.namespace, this.parents[0], 0, null, null, false), value, hints).getValue();
                    s = s + " " + t.toString();
                }
            }
            this.parents[0].encode(element, s, output, hints);
            return;
        }
        this.parents[0].encode(element, value, output, hints);
    }
}

