/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata;
import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageWriter;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageWriterSpi;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.Interpolation;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;

public final class ArcGridWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.arcgrid");
    private AsciiGridsImageWriter mWriter = new AsciiGridsImageWriter((ImageWriterSpi)new AsciiGridsImageWriterSpi());
    private static final ParameterValueGroup bandSelectParams;
    private static final ParameterValueGroup reShapeParams;
    private static final Resample resampleFactory;
    private static final SelectSampleDimension bandSelectFactory;
    private static final double ROTATION_EPS = 0.001;
    private int writeBand = -1;

    public ArcGridWriter(Object destination) throws DataSourceException {
        this(destination, null);
    }

    public ArcGridWriter(Object destination, Hints hints) throws DataSourceException {
        this.destination = destination;
        if (destination instanceof File) {
            try {
                this.outStream = ImageIO.createImageOutputStream(destination);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                throw new DataSourceException(e);
            }
        } else if (destination instanceof URL) {
            URL dest = (URL)destination;
            if (dest.getProtocol().equalsIgnoreCase("file")) {
                File destFile = DataUtilities.urlToFile(dest);
                try {
                    this.outStream = ImageIO.createImageOutputStream(destFile);
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    throw new DataSourceException(e);
                }
            }
        } else if (destination instanceof OutputStream) {
            try {
                this.outStream = ImageIO.createImageOutputStream((OutputStream)destination);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                throw new DataSourceException(e);
            }
        } else if (destination instanceof ImageOutputStream) {
            this.outStream = (ImageOutputStream)destination;
            this.destination = this.outStream;
        } else {
            throw new DataSourceException("The provided destination cannot be used!");
        }
        if (hints != null) {
            if (this.hints == null) {
                this.hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            this.hints.add((RenderingHints)hints);
        }
    }

    public Format getFormat() {
        return new ArcGridFormat();
    }

    private void writeGridCoverage(GridCoverage2D gc, GeneralParameterValue[] parameters) throws DataSourceException {
        try {
            ArcGridWriteParams gtParams = null;
            boolean grass = false;
            boolean forceCellSize = false;
            String grassParam = ArcGridFormat.GRASS.getName().getCode().toString();
            String cellSizeParam = ArcGridFormat.FORCE_CELLSIZE.getName().getCode().toString();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter param = (Parameter)parameters[i];
                    String name = param.getDescriptor().getName().toString();
                    if (param.getDescriptor().getName().getCode().equals(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString())) {
                        gtParams = (GeoToolsWriteParams)param.getValue();
                    }
                    if (name.equalsIgnoreCase(grassParam)) {
                        grass = param.booleanValue();
                    }
                    if (!name.equalsIgnoreCase(cellSizeParam)) continue;
                    forceCellSize = param.booleanValue();
                }
            }
            if (gtParams == null) {
                gtParams = new ArcGridWriteParams();
            }
            int[] writeBands = gtParams.getSourceBands();
            this.writeBand = CoverageUtilities.getVisibleBand((Object)gc.getRenderedImage());
            if (!(writeBands != null && writeBands.length != 0 && writeBands.length <= 1 || this.writeBand >= 0 && this.writeBand <= gc.getNumSampleDimensions())) {
                throw new IllegalArgumentException("You need to supply a valid index for deciding which band to write.");
            }
            if (writeBands != null && writeBands.length != 0 && writeBands.length <= 1) {
                this.writeBand = writeBands[0];
            }
            CoordinateReferenceSystem crs = gc.getCoordinateReferenceSystem2D();
            int numBands = gc.getNumSampleDimensions();
            if (numBands > 1) {
                int visibleBand = this.writeBand > 0 && this.writeBand < numBands ? this.writeBand : CoverageUtilities.getVisibleBand((Object)gc);
                ParameterValueGroup param = bandSelectParams.clone();
                param.parameter("source").setValue((Object)gc);
                param.parameter("SampleDimensions").setValue((Object)new int[]{visibleBand});
                gc = (GridCoverage2D)bandSelectFactory.doOperation(param, null);
            }
            if (!grass && forceCellSize) {
                gc = this.reShapeData(gc);
            }
            Envelope2D newEnv = gc.getEnvelope2D();
            AffineTransform gridToWorld = (AffineTransform)gc.getGridGeometry().getGridToCRS2D();
            double xl = newEnv.getLowerCorner().getOrdinate(0);
            double yl = newEnv.getLowerCorner().getOrdinate(1);
            double cellsizeX = Math.abs(gridToWorld.getScaleX());
            double cellsizeY = Math.abs(gridToWorld.getScaleY());
            RenderedImage source = gc.getRenderedImage();
            int cols = source.getWidth();
            int rows = source.getHeight();
            this.mWriter.setOutput((Object)this.outStream);
            double inNoData = ArcGridWriter.getCandidateNoData(gc);
            this.mWriter.write(null, new IIOImage(source, null, (IIOMetadata)new AsciiGridsImageMetadata(cols, rows, cellsizeX, cellsizeY, xl, yl, true, grass, inNoData)), null);
            this.writeCRSInfo(crs);
            this.mWriter.dispose();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException(e);
        }
    }

    private GridCoverage2D reShapeData(GridCoverage2D gc) {
        double dy;
        AffineTransform gridToWorld = (AffineTransform)gc.getGridGeometry().getGridToCRS2D();
        double dx = XAffineTransform.getScaleX0((AffineTransform)gridToWorld);
        if (AsciiGridsImageWriter.resolutionCheck((double)dx, (double)(dy = XAffineTransform.getScaleY0((AffineTransform)gridToWorld)), (double)0.001)) {
            return gc;
        }
        RenderedImage image = gc.getRenderedImage();
        int Nx = image.getWidth();
        int Ny = image.getHeight();
        Envelope2D oldEnv = gc.getEnvelope2D();
        double W = oldEnv.getSpan(0);
        double H = oldEnv.getSpan(1);
        if (dx - dy > 0.001) {
            double _Nx = W / dy;
            Nx = (int)(_Nx + 0.5);
        } else {
            double _Ny = H / dx;
            Ny = (int)(_Ny + 0.5);
        }
        GeneralGridEnvelope newGridrange = new GeneralGridEnvelope(new int[]{0, 0}, new int[]{Nx, Ny});
        GridGeometry2D newGridGeometry = new GridGeometry2D((GridEnvelope)newGridrange, (Envelope)new GeneralEnvelope(gc.getEnvelope()));
        ParameterValueGroup param = reShapeParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)gc.getCoordinateReferenceSystem2D());
        param.parameter("GridGeometry").setValue((Object)newGridGeometry);
        param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
        return (GridCoverage2D)resampleFactory.doOperation(param, this.hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCRSInfo(CoordinateReferenceSystem crs) throws IOException {
        if (crs == null) {
            throw new NullPointerException("CRS cannot be null!");
        }
        URL url = null;
        if (this.destination instanceof String) {
            url = new File((String)this.destination).toURI().toURL();
        } else if (this.destination instanceof File) {
            url = ((File)this.destination).toURI().toURL();
        } else if (this.destination instanceof URL) {
            url = (URL)this.destination;
        } else {
            return;
        }
        File ascFile = DataUtilities.urlToFile(url);
        String prjName = ascFile.getName().substring(0, ascFile.getName().lastIndexOf(".")) + ".prj";
        File prjFile = new File(ascFile.getParent(), prjName);
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(prjFile));
        try {
            fileWriter.write(crs.toWKT());
        }
        finally {
            block15: {
                try {
                    fileWriter.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block15;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void write(GridCoverage coverage, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        this.ensureWeCanWrite(coverage, parameters);
        this.writeGridCoverage((GridCoverage2D)coverage, parameters);
    }

    private void ensureWeCanWrite(GridCoverage coverage, GeneralParameterValue[] parameters) throws IOException {
        AffineTransform gridToWorldTransform = new AffineTransform((AffineTransform)((GridGeometry2D)coverage.getGridGeometry()).getGridToCRS2D());
        int swapXY = XAffineTransform.getSwapXY((AffineTransform)gridToWorldTransform);
        XAffineTransform.round((AffineTransform)gridToWorldTransform, (double)0.001);
        double rotation = XAffineTransform.getRotation((AffineTransform)gridToWorldTransform);
        if (swapXY == -1) {
            throw new DataSourceException("Impossible to encode this coverage as an ascii grid since itstransformation is not a simple scale and translate");
        }
        if (rotation != 0.0) {
            throw new DataSourceException("Impossible to encode this coverage as an ascii grid since itstransformation is not a simple scale and translate");
        }
        int flip = XAffineTransform.getFlip((AffineTransform)gridToWorldTransform);
        CoordinateReferenceSystem crs2D = ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        if (flip > 0) {
            throw new DataSourceException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
        if (!AxisDirection.NORTH.equals((Object)crs2D.getCoordinateSystem().getAxis(1).getDirection())) {
            throw new DataSourceException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
        if (!AxisDirection.EAST.equals((Object)crs2D.getCoordinateSystem().getAxis(0).getDirection())) {
            throw new DataSourceException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
        if (coverage instanceof GridCoverage2D && !(coverage.getGridGeometry() instanceof GridGeometry2D)) {
            throw new DataSourceException("The provided coverage is not a GridCoverage2D");
        }
    }

    public void dispose() {
        if (this.mWriter != null) {
            this.mWriter.dispose();
            this.mWriter = null;
        }
    }

    static double getCandidateNoData(GridCoverage2D gc) {
        GridSampleDimension sd = gc.getSampleDimension(0);
        List categories = sd.getCategories();
        Iterator it = categories.iterator();
        double inNoData = Double.NaN;
        String noDataName = Vocabulary.format((int)147);
        while (it.hasNext()) {
            Category candidate = (Category)it.next();
            String name = candidate.getName().toString();
            if (!name.equalsIgnoreCase("No Data") && !name.equalsIgnoreCase(noDataName)) continue;
            inNoData = candidate.getRange().getMaximum();
        }
        return inNoData;
    }

    static {
        resampleFactory = new Resample();
        bandSelectFactory = new SelectSampleDimension();
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        bandSelectParams = processor.getOperation("SelectSampleDimension").getParameters();
        reShapeParams = processor.getOperation("Resample").getParameters();
    }
}

