/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.core;

import it.geosolutions.imageio.core.GCP;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreCommonImageMetadata
extends IIOMetadata {
    private static final Logger LOGGER = Logger.getLogger(CoreCommonImageMetadata.class.toString());
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_core_commonImageMetadata_1.0";
    public static final String nativeMetadataFormatClassName = "it.geosolutions.imageio.core.CommonImageMetadataFormat";
    private String driverName;
    private String driverDescription;
    private String datasetName;
    private String datasetDescription;
    private String projection;
    private int gcpNumber;
    private String gcpProjection;
    private double[] geoTransformation;
    private List<GCP> gcps = Collections.emptyList();
    private int width;
    private int height;
    private int tileHeight;
    private int tileWidth;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private int numBands;
    private Double[] maximums;
    private Double[] minimums;
    private Double[] noDataValues;
    private Double[] scales;
    private Double[] offsets;
    private int[] numOverviews;
    private int[] colorInterpretations;

    protected CoreCommonImageMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        super(standardMetadataFormatSupported, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
    }

    protected Node createCommonNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode("DatasetDescriptor");
        node.setAttribute("name", this.datasetName);
        node.setAttribute("description", this.datasetDescription);
        node.setAttribute("driverName", this.driverName);
        node.setAttribute("driverDescription", this.driverDescription);
        node.setAttribute("projection", this.projection);
        node.setAttribute("numGCPs", Integer.toString(this.gcpNumber));
        node.setAttribute("gcpProjection", this.gcpProjection);
        root.appendChild(node);
        node = new IIOMetadataNode("RasterDimensions");
        node.setAttribute("width", Integer.toString(this.width));
        node.setAttribute("height", Integer.toString(this.height));
        node.setAttribute("tileWidth", Integer.toString(this.tileWidth));
        node.setAttribute("tileHeight", Integer.toString(this.tileHeight));
        node.setAttribute("numBands", Integer.toString(this.numBands));
        root.appendChild(node);
        node = new IIOMetadataNode("GeoTransform");
        boolean hasgeoTransform = this.geoTransformation != null && this.geoTransformation.length > 0;
        node.setAttribute("m0", hasgeoTransform ? Double.toString(this.geoTransformation[0]) : null);
        node.setAttribute("m1", hasgeoTransform ? Double.toString(this.geoTransformation[1]) : null);
        node.setAttribute("m2", hasgeoTransform ? Double.toString(this.geoTransformation[2]) : null);
        node.setAttribute("m3", hasgeoTransform ? Double.toString(this.geoTransformation[3]) : null);
        node.setAttribute("m4", hasgeoTransform ? Double.toString(this.geoTransformation[4]) : null);
        node.setAttribute("m5", hasgeoTransform ? Double.toString(this.geoTransformation[5]) : null);
        root.appendChild(node);
        if (this.gcpNumber > 0) {
            IIOMetadataNode nodeGCPs = new IIOMetadataNode("GCPS");
            List<? extends GCP> gcps = this.getGCPs();
            if (gcps != null && !gcps.isEmpty()) {
                Iterator<? extends GCP> it = gcps.iterator();
                while (it.hasNext()) {
                    node = new IIOMetadataNode("GCP");
                    GCP gcp = it.next();
                    node.setAttribute("x", Double.toString(gcp.getGCPPixel()));
                    node.setAttribute("y", Double.toString(gcp.getGCPLine()));
                    node.setAttribute("id", gcp.getId());
                    node.setAttribute("info", gcp.getInfo());
                    node.setAttribute("lon", Double.toString(gcp.getGCPX()));
                    node.setAttribute("lat", Double.toString(gcp.getGCPY()));
                    node.setAttribute("elevation", Double.toString(gcp.getGCPZ()));
                    nodeGCPs.appendChild(node);
                }
            }
            root.appendChild(nodeGCPs);
        }
        IIOMetadataNode bandsNode = new IIOMetadataNode("BandsInfo");
        for (int i = 0; i < this.numBands; ++i) {
            node = new IIOMetadataNode("BandInfo");
            node.setAttribute("index", Integer.toString(i));
            node.setAttribute("colorInterpretation", this.colorInterpretations != null && this.colorInterpretations.length > i ? Integer.toBinaryString(this.colorInterpretations[i]) : "");
            node.setAttribute("noData", this.noDataValues != null && this.noDataValues.length > i && this.noDataValues[i] != null ? this.noDataValues[i].toString() : null);
            node.setAttribute("maximum", this.maximums != null && this.maximums.length > i && this.maximums[i] != null ? this.maximums[i].toString() : null);
            node.setAttribute("minimum", this.minimums != null && this.minimums.length > i && this.minimums[i] != null ? this.minimums[i].toString() : null);
            node.setAttribute("scale", this.scales != null && this.scales.length > i && this.scales[i] != null ? this.scales[i].toString() : null);
            node.setAttribute("offset", this.offsets != null && this.offsets.length > i && this.offsets[i] != null ? this.offsets[i].toString() : null);
            node.setAttribute("numOverviews", this.numOverviews != null && this.numOverviews.length > i ? Integer.toString(this.numOverviews[i]) : null);
            bandsNode.appendChild(node);
        }
        if (this.colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.colorModel;
            int mapSize = icm.getMapSize();
            IIOMetadataNode node1 = new IIOMetadataNode("ColorTable");
            node1.setAttribute("sizeOfLocalColorTable", Integer.toString(mapSize));
            byte[][] rgb = new byte[3][mapSize];
            icm.getReds(rgb[0]);
            icm.getReds(rgb[1]);
            icm.getReds(rgb[2]);
            for (int i = 0; i < mapSize; ++i) {
                IIOMetadataNode nodeEntry = new IIOMetadataNode("ColorTableEntry");
                nodeEntry.setAttribute("index", Integer.toString(i));
                nodeEntry.setAttribute("red", Byte.toString(rgb[0][i]));
                nodeEntry.setAttribute("green", Byte.toString(rgb[1][i]));
                nodeEntry.setAttribute("blue", Byte.toString(rgb[2][i]));
                nodeEntry.setAttribute("alpha", Byte.toString(rgb[3][i]));
                node1.appendChild(nodeEntry);
            }
            node.appendChild(node1);
        }
        root.appendChild(bandsNode);
        return root;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            return this.createCommonNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDescription() {
        return this.datasetDescription;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverDescription() {
        return this.driverDescription;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    public final SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public String getProjection() {
        return this.projection;
    }

    protected Double[] getMaximums() {
        return (Double[])this.maximums.clone();
    }

    protected void setMaximums(Double[] maximums) {
        if (this.maximums != null) {
            throw new UnsupportedOperationException("maximums have already been defined");
        }
        this.maximums = maximums;
    }

    protected Double[] getMinimums() {
        return (Double[])this.minimums.clone();
    }

    protected void setMinimums(Double[] minimums) {
        if (this.minimums != null) {
            throw new UnsupportedOperationException("minimums have already been defined");
        }
        this.minimums = minimums;
    }

    protected Double[] getNoDataValues() {
        return (Double[])this.noDataValues.clone();
    }

    protected void setNoDataValues(Double[] noDataValues) {
        if (this.noDataValues != null) {
            throw new UnsupportedOperationException("noDataValues have already been defined");
        }
        this.noDataValues = noDataValues;
    }

    protected Double[] getScales() {
        return (Double[])this.scales.clone();
    }

    protected void setScales(Double[] scales) {
        if (this.scales != null) {
            throw new UnsupportedOperationException("scales have already been defined");
        }
        this.scales = scales;
    }

    protected Double[] getOffsets() {
        return (Double[])this.offsets.clone();
    }

    protected void setOffsets(Double[] offsets) {
        if (this.offsets != null) {
            throw new UnsupportedOperationException("offsets have already been defined");
        }
        this.offsets = offsets;
    }

    protected int[] getNumOverviews() {
        return (int[])this.numOverviews.clone();
    }

    protected void setNumOverviews(int[] numOverviews) {
        this.numOverviews = (int[])numOverviews.clone();
    }

    public void setGcps(List<GCP> gcps) {
        this.gcps = gcps;
    }

    public double[] getGeoTransformation() {
        return (double[])this.geoTransformation.clone();
    }

    public int getGcpNumber() {
        return this.gcpNumber;
    }

    public String getGcpProjection() {
        return this.gcpProjection;
    }

    public List<? extends GCP> getGCPs() {
        return this.gcps;
    }

    public int getNumOverviews(int bandIndex) {
        this.checkBandIndex(bandIndex);
        return this.numOverviews[bandIndex];
    }

    public int getColorInterpretations(int bandIndex) {
        this.checkBandIndex(bandIndex);
        return this.colorInterpretations[bandIndex];
    }

    public double getMaximum(int bandIndex) throws IllegalArgumentException {
        Double maximum;
        this.checkBandIndex(bandIndex);
        if (this.maximums != null && (maximum = this.maximums[bandIndex]) != null) {
            return maximum;
        }
        throw new IllegalArgumentException("no maximum value available for the specified band " + bandIndex);
    }

    public double getMinimum(int bandIndex) throws IllegalArgumentException {
        Double minimum;
        this.checkBandIndex(bandIndex);
        if (this.minimums != null && (minimum = this.minimums[bandIndex]) != null) {
            return minimum;
        }
        throw new IllegalArgumentException("no minimum value available for the specified band " + bandIndex);
    }

    public double getScale(int bandIndex) throws IllegalArgumentException {
        Double scale;
        this.checkBandIndex(bandIndex);
        if (this.scales != null && (scale = this.scales[bandIndex]) != null) {
            return scale;
        }
        throw new IllegalArgumentException("no scale value available for the specified band " + bandIndex);
    }

    public double getOffset(int bandIndex) throws IllegalArgumentException {
        Double offset;
        this.checkBandIndex(bandIndex);
        if (this.offsets != null && (offset = this.offsets[bandIndex]) != null) {
            return offset;
        }
        throw new IllegalArgumentException("no Offset value available for the specified band " + bandIndex);
    }

    public double getNoDataValue(int bandIndex) throws IllegalArgumentException {
        Double noDataValue;
        this.checkBandIndex(bandIndex);
        if (this.noDataValues != null && (noDataValue = this.noDataValues[bandIndex]) != null) {
            return noDataValue;
        }
        throw new IllegalArgumentException("no noDataValue available for the specified band " + bandIndex);
    }

    private void checkBandIndex(int bandIndex) throws IllegalArgumentException {
        if (bandIndex < 0 || bandIndex > this.numBands) {
            StringBuffer sb = new StringBuffer("Specified band index (").append(bandIndex).append(") is out of range. It should be in the range [0,").append(this.numBands - 1).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public String getDatasetDescription() {
        return this.datasetDescription;
    }

    public void setDatasetDescription(String datasetDescription) {
        this.datasetDescription = datasetDescription;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setDriverDescription(String driverDescription) {
        this.driverDescription = driverDescription;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public void setGcpNumber(int gcpNumber) {
        this.gcpNumber = gcpNumber;
    }

    public void setGcpProjection(String gcpProjection) {
        this.gcpProjection = gcpProjection;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    protected void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    protected void setSampleModel(SampleModel sampleModel) {
        this.sampleModel = sampleModel;
    }

    public void setNumBands(int numBands) {
        this.numBands = numBands;
    }

    protected void setGeoTransformation(double[] geoTransformation) {
        if (this.geoTransformation != null) {
            throw new UnsupportedOperationException("geoTransformation have already been defined");
        }
        this.geoTransformation = geoTransformation;
    }

    protected int[] getColorInterpretations() {
        return (int[])this.colorInterpretations.clone();
    }

    protected void setColorInterpretations(int[] colorInterpretations) {
        if (this.colorInterpretations != null) {
            throw new UnsupportedOperationException("colorInterpretations have already been defined");
        }
        this.colorInterpretations = colorInterpretations;
    }
}

