/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.filter.Filters;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Graphic;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.picocontainer.MutablePicoContainer;

public class SLDStrokeBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDStrokeBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.STROKE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Stroke.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Expression color = null;
        Expression opacity = null;
        Expression width = null;
        Expression lineJoin = null;
        Expression lineCap = null;
        Expression dashArray = null;
        Expression dashOffset = null;
        for (CssParameter css : node.getChildValues(CssParameter.class)) {
            if (css.getExpressions().isEmpty()) continue;
            if ("stroke".equals(css.getName())) {
                color = (Expression)css.getExpressions().get(0);
                continue;
            }
            if ("stroke-opacity".equals(css.getName())) {
                opacity = (Expression)css.getExpressions().get(0);
                continue;
            }
            if ("stroke-width".equals(css.getName())) {
                width = (Expression)css.getExpressions().get(0);
                continue;
            }
            if ("stroke-linejoin".equals(css.getName())) {
                lineJoin = (Expression)css.getExpressions().get(0);
                continue;
            }
            if ("stroke-linecap".equals(css.getName())) {
                lineCap = (Expression)css.getExpressions().get(0);
                continue;
            }
            if ("stroke-dasharray".equals(css.getName())) {
                dashArray = (Expression)css.getExpressions().get(0);
                continue;
            }
            if (!"stroke-dashoffset".equals(css.getName())) continue;
            dashOffset = (Expression)css.getExpressions().get(0);
        }
        float[] dash = null;
        if (dashArray != null) {
            String[] string = Filters.asString(dashArray).split(" +");
            dash = new float[string.length];
            for (int i = 0; i < string.length; ++i) {
                dash[i] = Float.parseFloat(string[i]);
            }
        }
        Graphic graphicFill = (Graphic)node.getChildValue("GraphicFill");
        Graphic graphicStroke = (Graphic)node.getChildValue("GraphicStroke");
        return this.styleFactory.createStroke(color, width, opacity, lineJoin, lineCap, dash, dashOffset, graphicFill, graphicStroke);
    }
}

