/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.util.ServletUtils;

public class WFSObject
extends StorageObject {
    public static final String TYPE = "wfs";
    long wfs_id = -1L;
    String parameters;
    int query_blob_size = -1;
    byte[] query_blob;
    String query_blob_md5;
    InputStream wfsInputStream;

    public static WFSObject createCompleteWFSObject(String parameters) {
        WFSObject obj = WFSObject.createQueryWFSObject(parameters);
        obj.created = System.currentTimeMillis();
        return obj;
    }

    public static WFSObject createCompleteWFSObject(byte[] queryBlob) {
        WFSObject obj = WFSObject.createQueryWFSObject(queryBlob);
        obj.created = System.currentTimeMillis();
        return obj;
    }

    public static WFSObject createQueryWFSObject(String parameters) {
        WFSObject obj = new WFSObject();
        obj.parameters = parameters;
        return obj;
    }

    public static WFSObject createQueryWFSObject(byte[] queryBlob) {
        WFSObject obj = new WFSObject();
        obj.setQueryBlob(queryBlob);
        return obj;
    }

    private WFSObject() {
    }

    public long getId() {
        return this.wfs_id;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getType() {
        return TYPE;
    }

    public byte[] getQueryBlob() {
        return this.query_blob;
    }

    public String getQueryBlobMd5() {
        return this.query_blob_md5;
    }

    public InputStream getInputStream() {
        return this.wfsInputStream;
    }

    public void setInputStream(InputStream is) {
        this.wfsInputStream = is;
    }

    public int getQueryBlobSize() {
        return this.query_blob_size;
    }

    public void setId(long id) {
        this.wfs_id = id;
    }

    private void setQueryBlob(byte[] query_blob) {
        this.query_blob = query_blob;
        this.query_blob_size = query_blob.length;
        this.query_blob_md5 = WFSObject.calculateMd5(query_blob);
    }

    private static String calculateMd5(byte[] queryBlob) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (digest != null) {
            digest.update(queryBlob);
        }
        return ServletUtils.hexOfBytes(digest.digest());
    }
}

