/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;

public class WMSRequests {
    private static Log log = LogFactory.getLog(WMSRequests.class);

    public static void handleProxy(TileLayerDispatcher tld, ConveyorTile tile) throws GeoWebCacheException {
        WMSLayer layer = null;
        TileLayer tl = tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        if (!(tl instanceof WMSLayer)) {
            throw new GeoWebCacheException(tile.getLayerId() + " is not served by a WMS backend.");
        }
        layer = (WMSLayer)tl;
        String queryStr = tile.servletReq.getQueryString();
        String serverStr = layer.getWMSurl()[0];
        try {
            URL url = serverStr.endsWith("?") ? new URL(serverStr + queryStr) : new URL(serverStr + "?" + queryStr);
            HttpURLConnection wmsBackendCon = (HttpURLConnection)url.openConnection();
            HttpServletResponse response = tile.servletResp;
            if (wmsBackendCon.getContentEncoding() != null) {
                response.setCharacterEncoding(wmsBackendCon.getContentEncoding());
            }
            response.setContentType(wmsBackendCon.getContentType());
            int read = 0;
            byte[] data = new byte[1024];
            while (read > -1) {
                read = wmsBackendCon.getInputStream().read(data);
                if (read <= -1) continue;
                response.getOutputStream().write(data, 0, read);
            }
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.error((Object)ioe.getMessage());
        }
    }
}

