/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.TileRangeIterator;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;

public class SeedTask
extends GWCTask {
    private static Log log = LogFactory.getLog(SeedTask.class);
    private final TileRangeIterator trIter;
    private final TileLayer tl;
    private boolean reseed;
    private boolean doFilterUpdate;
    private StorageBroker storageBroker;

    public SeedTask(StorageBroker sb, TileRangeIterator trIter, TileLayer tl, boolean reseed, boolean doFilterUpdate) {
        this.storageBroker = sb;
        this.trIter = trIter;
        this.tl = tl;
        this.reseed = reseed;
        this.doFilterUpdate = doFilterUpdate;
        this.type = reseed ? GWCTask.TYPE.RESEED : GWCTask.TYPE.SEED;
        this.layerName = tl.getName();
        this.state = GWCTask.STATE.READY;
    }

    public void doAction() throws GeoWebCacheException {
        this.state = GWCTask.STATE.RUNNING;
        Thread.currentThread().setPriority(3);
        long START_TIME = System.currentTimeMillis();
        log.info((Object)("Thread " + this.threadOffset + " begins seeding layer : " + this.tl.getName()));
        int arrayIndex = this.getCurrentThreadArrayIndex();
        TileRange tr = this.trIter.getTileRange();
        this.tilesTotal = this.tileCount(tr.rangeBounds, tr.zoomStart, tr.zoomStop);
        boolean tryCache = !this.reseed;
        long[] gridLoc = this.trIter.nextMetaGridLocation();
        while (gridLoc != null && !this.terminate) {
            ConveyorTile tile = new ConveyorTile(this.storageBroker, this.tl.getName(), tr.gridSetId, gridLoc, tr.mimeType, null, null, null, null);
            try {
                this.tl.seedTile(tile, tryCache);
            }
            catch (IOException ioe) {
                log.error((Object)("Seed failed at " + tile.toString() + ",\n exception: " + ioe.getMessage()));
                this.state = GWCTask.STATE.DEAD;
                throw new GeoWebCacheException(ioe.getMessage());
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)("Seed failed at " + tile.toString() + ",\n exception: " + gwce.getMessage()));
                this.state = GWCTask.STATE.DEAD;
                throw gwce;
            }
            log.debug((Object)("Thread " + this.threadOffset + " seeded " + Arrays.toString(gridLoc)));
            long totalTilesCompleted = this.trIter.getCountRendered() + this.trIter.getCountRendered();
            this.updateStatusInfo(arrayIndex, this.tl, totalTilesCompleted, START_TIME);
            gridLoc = this.trIter.nextMetaGridLocation();
        }
        if (this.terminate) {
            log.info((Object)("Thread " + this.threadOffset + " was terminated after " + this.tilesDone + " tiles"));
        } else {
            log.info((Object)("Thread " + this.threadOffset + " completed (re)seeding layer " + this.tl.getName() + " after " + this.tilesDone + " tiles."));
        }
        if (this.threadOffset == 0 && this.doFilterUpdate) {
            this.runFilterUpdates(tr.gridSetId);
        }
        this.state = GWCTask.STATE.DONE;
    }

    private long tileCount(long[][] coveredGridLevels, int startZoom, int stopZoom) {
        long count = 0L;
        for (int i = startZoom; i <= stopZoom; ++i) {
            long[] gridBounds = coveredGridLevels[i];
            long thisLevel = (1L + gridBounds[2] - gridBounds[0]) * (1L + gridBounds[3] - gridBounds[1]);
            if (thisLevel > 0x1FFFFFFFFFFFFFFFL && i != stopZoom) {
                return -1L;
            }
            count += thisLevel;
        }
        return count;
    }

    private int getCurrentThreadArrayIndex() {
        String tn = Thread.currentThread().getName();
        int indexOfnumber = tn.indexOf(100) + 2;
        String tmp = tn.substring(indexOfnumber);
        return Integer.parseInt(tmp) - 1;
    }

    private void updateStatusInfo(int arrayIndex, TileLayer layer, long tilesCount, long start_time) {
        this.tilesDone = tilesCount;
        this.timeSpent = (int)(System.currentTimeMillis() - start_time) / 1000;
        long timeTotal = Math.round((double)this.timeSpent * ((double)this.tilesTotal / (double)tilesCount));
        this.timeRemaining = (int)(timeTotal - this.timeSpent);
    }

    private void runFilterUpdates(String gridSetId) {
        List<RequestFilter> reqFilters = this.tl.getRequestFilters();
        if (reqFilters != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, gridSetId)) {
                    log.info((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }
}

