/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest;

import com.noelios.restlet.ext.servlet.ServletConverter;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.rest.GWCResource;
import org.geowebcache.rest.IndexRestlet;
import org.geowebcache.rest.RestletException;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.resource.StringRepresentation;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTDispatcher
extends AbstractController {
    private static Log log = LogFactory.getLog(RESTDispatcher.class);
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    ServletConverter myConverter;
    private Router myRouter = new Router();

    public RESTDispatcher(Map<String, Object> map) {
        this.setSupportedMethods(new String[]{"GET", "POST", METHOD_PUT, METHOD_DELETE, "HEAD"});
        this.addRoutes(map);
        this.myRouter.attach("", (Restlet)new IndexRestlet(this.myRouter));
        log.info((Object)("Created RESTDispatcher with " + map.size() + " paths"));
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.myConverter = new ServletConverter(this.getServletContext());
        this.myConverter.setTarget((Restlet)this.myRouter);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            this.myConverter.service(req, resp);
        }
        catch (Exception e) {
            RestletException re = null;
            if (e instanceof RestletException) {
                re = (RestletException)e;
            }
            if (re == null && e.getCause() instanceof RestletException) {
                re = (RestletException)e.getCause();
            }
            if (re != null) {
                resp.setStatus(re.getStatus().getCode());
                String reStr = re.getRepresentation().getText();
                resp.getOutputStream().write(reStr.getBytes());
                resp.getOutputStream().flush();
            }
            resp.setStatus(500);
            new StringRepresentation((CharSequence)e.getMessage()).write((OutputStream)resp.getOutputStream());
            resp.getOutputStream().flush();
        }
        return null;
    }

    private void addRoutes(Map<String, Object> m) {
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            if (entry.getValue() instanceof GWCResource) {
                this.myRouter.attach(entry.getKey().toString(), ((Object)((Object)((GWCResource)((Object)entry.getValue())))).getClass());
                continue;
            }
            if (entry.getValue() instanceof Restlet) {
                this.myRouter.attach(entry.getKey().toString(), (Restlet)entry.getValue());
                continue;
            }
            log.error((Object)("Unexpected " + entry.getValue()));
        }
    }
}

