/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.operator.CropDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;

public class WMSMetaTile
extends MetaTile {
    private static Log log = LogFactory.getLog(WMSMetaTile.class);
    private BufferedImage img = null;
    private RenderedImage[] tiles = null;
    private final RenderingHints no_cache = new RenderingHints(JAI.KEY_TILE_CACHE, null);
    protected WMSLayer wmsLayer = null;
    protected boolean requestTiled = false;
    protected String fullParameters;
    protected int[] gutter = new int[4];

    protected WMSMetaTile(WMSLayer layer, GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY, String fullParameters) {
        super(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY);
        this.wmsLayer = layer;
        this.fullParameters = fullParameters;
    }

    protected String getWMSParams() throws GeoWebCacheException {
        String baseParameters = this.wmsLayer.getWMSRequestTemplate(this.getResponseFormat(), WMSLayer.RequestType.MAP);
        BoundingBox metaBbox = this.gridSubset.boundsFromRectangle(this.metaGridCov);
        StringBuilder strBuilder = new StringBuilder(baseParameters);
        if (this.formatModifier == null) {
            strBuilder.append("&FORMAT=").append(this.responseFormat.getFormat());
        } else {
            strBuilder.append("&FORMAT=").append(this.formatModifier.getRequestFormat().getFormat());
        }
        strBuilder.append("&SRS=").append(this.wmsLayer.backendSRSOverride(this.gridSubset.getSRS()));
        if (this.wmsLayer.gutter == 0 || this.metaX * this.metaY == 1) {
            strBuilder.append("&WIDTH=").append(this.metaX * this.gridSubset.getTileWidth());
            strBuilder.append("&HEIGHT=").append(this.metaY * this.gridSubset.getTileHeight());
            strBuilder.append("&BBOX=").append(metaBbox);
        } else {
            this.adjustParamsForGutter(strBuilder);
        }
        strBuilder.append(this.fullParameters);
        return strBuilder.toString();
    }

    protected void adjustParamsForGutter(StringBuilder strBuilder) throws GeoWebCacheException {
        long[] layerCov = this.gridSubset.getCoverage((int)this.metaGridCov[4]);
        BoundingBox metaBbox = this.gridSubset.boundsFromRectangle(this.metaGridCov);
        double[] metaCoords = metaBbox.coords;
        long pixelWidth = this.metaX * this.gridSubset.getTileWidth();
        long pixelHeight = this.metaY * this.gridSubset.getTileHeight();
        double widthRelDelta = (1.0 * (double)pixelWidth + (double)this.wmsLayer.gutter.intValue()) / (double)pixelWidth - 1.0;
        double heightRelDelta = (1.0 * (double)pixelHeight + (double)this.wmsLayer.gutter.intValue()) / (double)pixelHeight - 1.0;
        double coordWidth = metaCoords[2] - metaCoords[0];
        double coordHeight = metaCoords[3] - metaCoords[1];
        double coordWidthDelta = coordWidth * widthRelDelta;
        double coordHeightDelta = coordHeight * heightRelDelta;
        if (layerCov[0] < this.metaGridCov[0]) {
            pixelWidth += (long)this.wmsLayer.gutter.intValue();
            this.gutter[0] = this.wmsLayer.gutter;
            metaCoords[0] = metaCoords[0] - coordWidthDelta;
        }
        if (layerCov[1] < this.metaGridCov[1]) {
            pixelHeight += (long)this.wmsLayer.gutter.intValue();
            this.gutter[1] = this.wmsLayer.gutter;
            metaCoords[1] = metaCoords[1] - coordHeightDelta;
        }
        if (layerCov[2] > this.metaGridCov[2]) {
            pixelWidth += (long)this.wmsLayer.gutter.intValue();
            this.gutter[2] = this.wmsLayer.gutter;
            metaCoords[2] = metaCoords[2] + coordWidthDelta;
        }
        if (layerCov[3] > this.metaGridCov[3]) {
            pixelHeight += (long)this.wmsLayer.gutter.intValue();
            this.gutter[3] = this.wmsLayer.gutter;
            metaCoords[3] = metaCoords[3] + coordHeightDelta;
        }
        strBuilder.append("&WIDTH=").append(pixelWidth);
        strBuilder.append("&HEIGHT=").append(pixelHeight);
        strBuilder.append("&BBOX=").append(metaBbox);
    }

    protected WMSLayer getLayer() {
        return this.wmsLayer;
    }

    protected void setImageBytes(byte[] image) throws GeoWebCacheException {
        if (image == null || image.length == 0) {
            throw new GeoWebCacheException("WMSMetaTile.setImageBytes()  received null instead of byte[]");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(image);
        try {
            this.img = ImageIO.read(is);
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("WMSMetaTile.setImageBytes() failed on ImageIO.read(byte[" + image.length + "])");
        }
        if (this.img == null) {
            throw new GeoWebCacheException("ImageIO.read(InputStream) returned null. Unable to read image.");
        }
    }

    protected void createTiles(int tileHeight, int tileWidth, boolean useJAI) {
        int tileCount = this.metaX * this.metaY;
        this.tiles = new RenderedImage[tileCount];
        if (tileCount > 1) {
            for (int y = 0; y < this.metaY; ++y) {
                for (int x = 0; x < this.metaX; ++x) {
                    int i = x * tileWidth + this.gutter[0];
                    int j = (this.metaY - 1 - y) * tileHeight + this.gutter[3];
                    this.tiles[y * this.metaX + x] = this.createTile(i, j, tileWidth, tileHeight, useJAI);
                }
            }
        } else {
            this.tiles[0] = this.img;
        }
    }

    private RenderedImage createTile(int minX, int minY, int tileWidth, int tileHeight, boolean useJAI) {
        BufferedImage tile = null;
        if (useJAI) {
            try {
                tile = CropDescriptor.create((RenderedImage)this.img, (Float)new Float(minX), (Float)new Float(minY), (Float)new Float(tileWidth), (Float)new Float(tileHeight), (RenderingHints)this.no_cache);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Error cropping, image is " + this.img.getWidth() + "x" + this.img.getHeight() + ", requesting a " + tileWidth + "x" + tileHeight + " tile starting at " + minX + "," + minY + "."));
                log.error((Object)("Message from JAI: " + iae.getMessage()));
                iae.printStackTrace();
            }
        } else {
            try {
                tile = this.img.getSubimage(minX, minY, tileWidth, tileHeight);
            }
            catch (RasterFormatException rfe) {
                log.error((Object)("RendereedImage.getSubimage(" + minX + "," + minY + "," + tileWidth + "," + tileHeight + ") threw exception:"));
                rfe.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thread: " + Thread.currentThread().getName() + "\n" + ((Object)tile).toString() + ", " + "Information from tile (width, height, minx, miny): " + tile.getWidth() + ", " + tile.getHeight() + ", " + tile.getMinX() + ", " + tile.getMinY() + "\n" + "Information set (width, height, minx, miny): " + new Float(tileWidth) + ", " + new Float(tileHeight) + ", " + new Float(minX) + ", " + new Float(minY)));
        }
        return tile;
    }

    protected boolean writeTileToStream(int tileIdx, OutputStream os) throws IOException {
        if (this.tiles != null) {
            String format = this.responseFormat.getInternalName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread: " + Thread.currentThread().getName() + " writing: " + tileIdx));
            }
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (this.formatModifier != null) {
                param = this.formatModifier.adjustImageWriteParam(param);
            }
            MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(os);
            writer.setOutput(imgOut);
            IIOImage image = new IIOImage(this.tiles[tileIdx], null, null);
            writer.write(null, image, param);
            imgOut.close();
            writer.dispose();
            return true;
        }
        return false;
    }

    public String debugString() {
        return " metaX: " + this.metaX + " metaY: " + this.metaY + " metaGridCov: " + Arrays.toString(this.metaGridCov);
    }
}

