/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileLayerDispatcher {
    private static Log log = LogFactory.getLog(TileLayerDispatcher.class);
    private HashMap<String, TileLayer> layers = null;
    private List<Configuration> configs = null;
    private GridSetBroker gridSetBroker = null;
    private ServiceInformation serviceInformation = null;

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<Configuration> configs) {
        this.gridSetBroker = gridSetBroker;
        this.configs = configs;
        ConfigurationLoader loader = new ConfigurationLoader(this, 2);
        loader.start();
    }

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<Configuration> configs, int loadDelay) {
        this.gridSetBroker = gridSetBroker;
        this.configs = configs;
        ConfigurationLoader loader = new ConfigurationLoader(this, loadDelay);
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileLayer getTileLayer(String layerIdent) throws GeoWebCacheException {
        TileLayer layer;
        TileLayerDispatcher tileLayerDispatcher = this;
        synchronized (tileLayerDispatcher) {
            layer = this.layers.get(layerIdent);
        }
        if (layer == null) {
            throw new GeoWebCacheException("Thread " + Thread.currentThread().getId() + " Unknown layer " + layerIdent + ". Check the logfiles," + " it may not have loaded properly.");
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reInit() throws GeoWebCacheException {
        TileLayerDispatcher tileLayerDispatcher = this;
        synchronized (tileLayerDispatcher) {
            this.layers = null;
            this.layers = this.initialize(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, TileLayer> getLayers() {
        HashMap<String, TileLayer> ret = null;
        TileLayerDispatcher tileLayerDispatcher = this;
        synchronized (tileLayerDispatcher) {
            ret = this.layers;
        }
        return ret;
    }

    private HashMap<String, TileLayer> initialize(boolean reload) {
        log.debug((Object)"Thread initLayers(), initializing");
        HashMap<String, TileLayer> newLayers = new HashMap<String, TileLayer>();
        Iterator<Configuration> configIter = this.configs.iterator();
        while (configIter.hasNext()) {
            List<TileLayer> configLayers = null;
            Configuration config = configIter.next();
            String configIdent = null;
            try {
                configIdent = config.getIdentifier();
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
            if (configIdent == null) continue;
            try {
                configLayers = config.getTileLayers(reload);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                log.error((Object)("Failed to add layers from " + configIdent));
            }
            log.info((Object)("Adding layers from " + configIdent));
            if (configLayers != null && configLayers.size() > 0) {
                for (TileLayer layer : configLayers) {
                    if (layer == null) {
                        log.error((Object)"layer was null");
                        continue;
                    }
                    log.info((Object)("Adding: " + layer.getName()));
                    layer.initialize(this.gridSetBroker);
                    this.add(layer, newLayers);
                }
            } else {
                log.error((Object)("Configuration " + configIdent + " contained no layers."));
            }
            if (this.serviceInformation != null) continue;
            try {
                this.serviceInformation = config.getServiceInformation();
            }
            catch (GeoWebCacheException e) {
                log.error((Object)("Error reading service information from " + configIdent + ": " + e.getMessage()));
            }
        }
        return newLayers;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public synchronized void update(TileLayer layer) {
        TileLayer oldLayer = this.layers.get(layer.getName());
        if (oldLayer != null) {
            oldLayer.acquireLayerLock();
            this.layers.remove(layer.getName());
            oldLayer.releaseLayerLock();
        }
        this.layers.put(layer.getName(), layer);
    }

    public synchronized void remove(String layerName) {
        TileLayer layer = this.layers.get(layerName);
        if (layer != null) {
            layer.acquireLayerLock();
            this.layers.remove(layerName);
            layer.releaseLayerLock();
        }
    }

    public synchronized void add(TileLayer layer) {
        this.add(layer, this.layers);
    }

    private synchronized void add(TileLayer layer, HashMap<String, TileLayer> layerMap) {
        if (layerMap.containsKey(layer.getName())) {
            try {
                layerMap.get(layer.getName()).mergeWith(layer);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
        } else {
            layerMap.put(layer.getName(), layer);
        }
    }

    private class ConfigurationLoader
    extends Thread {
        TileLayerDispatcher parent;
        int loadDelay;

        private ConfigurationLoader(TileLayerDispatcher parent, int loadDelay) {
            this.parent = parent;
            this.loadDelay = loadDelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TileLayerDispatcher tileLayerDispatcher = this.parent;
            synchronized (tileLayerDispatcher) {
                log.info((Object)"ConfigurationLoader acquired lock, sleeping 5 seconds");
                try {
                    Thread.sleep(this.loadDelay * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info((Object)"ConfigurationLoader woke up, initializing");
                this.parent.layers = this.parent.initialize(false);
                log.info((Object)"ConfigurationLoader completed");
            }
        }
    }
}

