/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.georss.Entry;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.TileGridFilterMatrix;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;

class GeoRSSTileRangeBuilder {
    private static final Log logger = LogFactory.getLog(GeoRSSTileRangeBuilder.class);
    private final TileLayer layer;
    private final String gridSetId;
    private final int maxMaskLevel;
    private String lastEntryUpdate;

    public GeoRSSTileRangeBuilder(TileLayer layer, String gridSetId, int maxMaskLevel) {
        if (layer == null) {
            throw new NullPointerException("layer");
        }
        if (gridSetId == null) {
            throw new NullPointerException("griSetId");
        }
        if (maxMaskLevel < 0) {
            throw new IllegalArgumentException("maxMaskLevel shall be >= 0: " + maxMaskLevel);
        }
        this.layer = layer;
        this.gridSetId = gridSetId;
        this.maxMaskLevel = maxMaskLevel;
        this.lastEntryUpdate = "";
        GridSubset gridSubset = layer.getGridSubset(gridSetId);
        if (gridSubset == null) {
            throw new IllegalArgumentException("no grid subset " + gridSetId + " at " + layer.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileGridFilterMatrix buildTileRangeMask(GeoRSSReader reader, String previousEntryUpdate) throws IOException {
        GridSubset gridSubset = this.layer.getGridSubset(this.gridSetId);
        int[] metaTilingFactors = this.layer.getMetaTilingFactors();
        TileGridFilterMatrix matrix = null;
        try {
            Entry entry;
            while ((entry = reader.nextEntry()) != null) {
                if (entry.getUpdated() != null && entry.getUpdated().equals(previousEntryUpdate)) {
                    logger.warn((Object)("Skipping entry with id " + entry.getId() + " since it has the same date as our last feed update."));
                    continue;
                }
                if (matrix == null) {
                    matrix = new TileGridFilterMatrix(gridSubset, metaTilingFactors, this.maxMaskLevel);
                    matrix.createGraphics();
                }
                this.lastEntryUpdate = entry.getUpdated();
                Geometry geom = entry.getWhere();
                matrix.setMasksForGeometry(geom);
            }
        }
        finally {
            if (matrix != null) {
                matrix.disposeGraphics();
            }
        }
        return matrix;
    }

    public String getLastEntryUpdate() {
        return this.lastEntryUpdate;
    }
}

