/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.GeoRSSReaderFactory;
import org.geowebcache.georss.GeoRSSTileRangeBuilder;
import org.geowebcache.georss.PollDef;
import org.geowebcache.georss.TileGridFilterMatrix;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.RasterMask;
import org.geowebcache.rest.seed.SeedRestlet;
import org.geowebcache.storage.DiscontinuousTileRange;

class GeoRSSPollTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(GeoRSSPollTask.class);
    private static final String LAST_UPDATE_URL_TEMPLATE = "${lastUpdate}";
    private final PollDef poll;
    private final SeedRestlet seedRestlet;
    private LinkedList<GWCTask> seedTasks = new LinkedList();
    private String lastUpdatedEntry = "";

    public GeoRSSPollTask(PollDef poll, SeedRestlet seedRestlet) {
        this.poll = poll;
        this.seedRestlet = seedRestlet;
    }

    public void run() {
        try {
            this.runPollAndLaunchSeed();
        }
        catch (Exception e) {
            logger.error((Object)("Error encountered trying to poll the GeoRSS feed " + this.poll.getPollDef().getFeedUrl() + ". Another attempt will be made after the poll interval of " + this.poll.getPollDef().getPollIntervalStr()), (Throwable)e);
        }
        catch (OutOfMemoryError error) {
            System.gc();
            logger.fatal((Object)("Out of memory error processing poll " + this.poll.getPollDef() + ". Need to reduce the maxMaskLevel param or increase system memory." + " Poll disabled."), (Throwable)error);
            throw error;
        }
    }

    private void runPollAndLaunchSeed() throws IOException {
        TileLayer layer = this.poll.getLayer();
        GeoRSSFeedDefinition pollDef = this.poll.getPollDef();
        logger.info((Object)("Polling GeoRSS feed for layer " + layer.getName() + ": " + pollDef.toString()));
        String gridSetId = pollDef.getGridSetId();
        URL feedUrl = new URL(this.templateFeedUrl(pollDef.getFeedUrl()));
        logger.debug((Object)("Getting GeoRSS reader for " + feedUrl.toExternalForm()));
        GeoRSSReaderFactory geoRSSReaderFactory = new GeoRSSReaderFactory();
        GeoRSSReader geoRSSReader = null;
        try {
            geoRSSReader = geoRSSReaderFactory.createReader(feedUrl);
        }
        catch (IOException ioe) {
            logger.error((Object)("Failed to fetch RSS feed from " + feedUrl + "\n" + ioe.getMessage()));
            return;
        }
        logger.debug((Object)("Got reader for " + pollDef.getFeedUrl() + ". Creating geometry filter matrix for gridset " + gridSetId + " on layer " + layer.getName()));
        int maxMaskLevel = pollDef.getMaxMaskLevel();
        GeoRSSTileRangeBuilder matrixBuilder = new GeoRSSTileRangeBuilder(layer, gridSetId, maxMaskLevel);
        logger.debug((Object)("Creating tile range mask based on GeoRSS feed's geometries from " + feedUrl.toExternalForm() + " for " + layer.getName()));
        TileGridFilterMatrix tileRangeMask = matrixBuilder.buildTileRangeMask(geoRSSReader, this.lastUpdatedEntry);
        if (tileRangeMask == null) {
            logger.info((Object)"Did not create a tileRangeMask, presumably no new entries in feed.");
            return;
        }
        this.lastUpdatedEntry = matrixBuilder.getLastEntryUpdate();
        logger.debug((Object)("Created tile range mask based on GeoRSS geometry feed from " + pollDef + " for " + layer.getName() + ". Calculating number of affected tiles..."));
        this._logImagesToDisk(tileRangeMask);
        boolean tilesAffected = tileRangeMask.hasTilesSet();
        if (!tilesAffected) {
            logger.info((Object)(pollDef + " for " + layer.getName() + " did not affect any tile. No need to reseed."));
            return;
        }
        logger.info((Object)("Launching reseed process " + pollDef + " for " + layer.getName()));
        this.launchSeeding(layer, pollDef, gridSetId, tileRangeMask);
        logger.info((Object)("Seeding process for tiles affected by feed " + feedUrl.toExternalForm() + " successfully launched."));
    }

    private String templateFeedUrl(String feedUrl) {
        if (feedUrl == null) {
            throw new NullPointerException("feedUrl");
        }
        String url = feedUrl;
        if (feedUrl.indexOf(LAST_UPDATE_URL_TEMPLATE) > -1) {
            url = feedUrl.replace(LAST_UPDATE_URL_TEMPLATE, this.lastUpdatedEntry);
            logger.info((Object)("Feed URL templated as '" + url + "'"));
        }
        return url;
    }

    private void _logImagesToDisk(TileGridFilterMatrix matrix) {
        if (null == System.getProperty("org.geowebcache.georss.debugToDisk")) {
            return;
        }
        File target = new File(System.getProperty("org.geowebcache.georss.debugToDisk"));
        if (!target.isDirectory() || !target.canWrite()) {
            throw new IllegalStateException("Can't access debug directory for dumping mask images: " + target.getAbsolutePath());
        }
        logger.warn((Object)"\n!!!!!!!!!!!\n REMEMBER NOT TO SET THE org.geowebcache.georss.debugToDisk SYSTEM PROPERTY ON A PRODUCTION ENVIRONMENT \n!!!!!!!!!!!");
        BufferedImage[] byLevelMasks = matrix.getByLevelMasks();
        for (int i = 0; i < byLevelMasks.length; ++i) {
            File output = new File(target, this.poll.getLayer().getName() + "_level_" + i + ".tiff");
            System.out.println("--- writing " + output.getAbsolutePath() + "---");
            try {
                ImageIO.write((RenderedImage)byLevelMasks[i], "TIFF", output);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void launchSeeding(TileLayer layer, GeoRSSFeedDefinition pollDef, String gridSetId, TileGridFilterMatrix tileRangeMask) {
        DiscontinuousTileRange dtr;
        GridSubset gridSub = layer.getGridSubset(gridSetId);
        long[][] fullCoverage = gridSub.getCoverages();
        long[][] coveredBounds = tileRangeMask.getCoveredBounds();
        BufferedImage[] byLevelMasks = tileRangeMask.getByLevelMasks();
        RasterMask rasterMask = new RasterMask(byLevelMasks, fullCoverage, coveredBounds);
        List<MimeType> mimeList = null;
        if (pollDef.getFormat() != null) {
            try {
                MimeType mime = MimeType.createFromFormat(pollDef.getFormat());
                mimeList = new LinkedList<MimeType>();
                mimeList.add(mime);
            }
            catch (MimeException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (mimeList == null) {
            mimeList = layer.getMimeTypes();
        }
        Iterator<Object> mimeIter = mimeList.iterator();
        this.stopSeeding(true);
        while (mimeIter.hasNext()) {
            dtr = new DiscontinuousTileRange(layer.getName(), gridSetId, gridSub.getZoomStart(), gridSub.getZoomStop(), rasterMask, (MimeType)mimeIter.next(), null);
            try {
                GWCTask[] tasks = this.seedRestlet.createTasks(dtr, layer, GWCTask.TYPE.TRUNCATE, 1, false);
                tasks[0].doAction();
            }
            catch (GeoWebCacheException e) {
                logger.error((Object)("Problem truncating based on GeoRSS feed: " + e.getMessage()));
            }
        }
        if (pollDef.getOperation() == GWCTask.TYPE.TRUNCATE) {
            logger.info((Object)("Truncation succeeded, won't seed as stated by poll def: " + pollDef));
            return;
        }
        mimeIter = mimeList.iterator();
        while (mimeIter.hasNext()) {
            dtr = new DiscontinuousTileRange(layer.getName(), gridSetId, gridSub.getZoomStart(), gridSub.getZoomStop(), rasterMask, (MimeType)mimeIter.next(), null);
            int seedingThreads = pollDef.getSeedingThreads();
            GWCTask[] tasks = this.seedRestlet.createTasks(dtr, layer, GWCTask.TYPE.SEED, seedingThreads, false);
            this.seedRestlet.dispatchTasks(tasks);
            for (GWCTask task : tasks) {
                this.seedTasks.add(task);
            }
        }
    }

    protected void stopSeeding(boolean checkLiveCount) {
        if (this.seedTasks != null) {
            int liveCount = 0;
            for (GWCTask task : this.seedTasks) {
                if (task.getState() == GWCTask.STATE.DEAD || task.getState() == GWCTask.STATE.DONE) continue;
                task.terminateNicely();
                ++liveCount;
            }
            Thread.yield();
            for (GWCTask task : this.seedTasks) {
                if (task.getState() == GWCTask.STATE.DEAD || task.getState() == GWCTask.STATE.DONE) continue;
                ++liveCount;
            }
            if (!checkLiveCount || liveCount == 0) {
                return;
            }
            try {
                logger.debug((Object)("Found " + liveCount + " running seed threads. Waiting 3s for them to terminate."));
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            liveCount = 0;
            Iterator iter = this.seedTasks.iterator();
            while (iter.hasNext()) {
                GWCTask task;
                task = (GWCTask)iter.next();
                if (task.getState() != GWCTask.STATE.DEAD && task.getState() != GWCTask.STATE.DONE) {
                    ++liveCount;
                    continue;
                }
                iter.remove();
            }
            if (liveCount > 0) {
                logger.info((Object)(liveCount + " seed jobs are still waiting to terminate, proceeding anyway."));
            }
        } else {
            logger.debug((Object)"Found no running seed jobs");
        }
    }
}

