/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;
    double[] x;
    double[] y;
    double[] z;

    public MultiLineHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.ARC;
        this.geometryFactory = gf;
    }

    public MultiLineHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints + 8 + 8 + 8 * numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return length;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString(null);
    }

    public Object readOld(ByteBuffer buffer, ShapeType type) {
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        LineString[] lines = new LineString[numParts];
        this.prepareCoordinateArrays(numPoints);
        for (t = 0; t < numPoints; ++t) {
            this.x[t] = buffer.getDouble();
            this.y[t] = buffer.getDouble();
        }
        if (dimensions == 3) {
            buffer.position(buffer.position() + 16);
            for (t = 0; t < numPoints; ++t) {
                this.z[t] = buffer.getDouble();
            }
        }
        int offset = 0;
        int start = 0;
        for (int part = 0; part < numParts; ++part) {
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            start = finish;
            CoordinateSequenceFactory csFactory = this.geometryFactory.getCoordinateSequenceFactory();
            CoordinateSequence cs = length == 1 ? csFactory.create(2, dimensions) : csFactory.create(length, dimensions);
            for (int i = 0; i < length; ++i) {
                cs.setOrdinate(i, 0, this.x[offset]);
                cs.setOrdinate(i, 1, this.y[offset]);
                if (dimensions == 3) {
                    cs.setOrdinate(i, 2, this.z[offset]);
                }
                ++offset;
            }
            if (length == 1) {
                cs.setOrdinate(1, 0, this.x[offset - 1]);
                cs.setOrdinate(1, 1, this.y[offset - 1]);
                if (dimensions == 3) {
                    cs.setOrdinate(1, 2, this.z[offset - 1]);
                }
            }
            lines[part] = this.geometryFactory.createLineString(cs);
        }
        return this.geometryFactory.createMultiLineString(lines);
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        int finish;
        int part;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimensions = this.shapeType == ShapeType.ARCZ ? 3 : 2;
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        for (part = 0; part < numParts; ++part) {
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - (start = partOffsets[part]);
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(length, dimensions);
            for (int i = 0; i < length; ++i) {
                cs.setOrdinate(i, 0, buffer.getDouble());
                cs.setOrdinate(i, 1, buffer.getDouble());
            }
            if (clonePoint) {
                cs.setOrdinate(1, 0, cs.getOrdinate(0, 0));
                cs.setOrdinate(1, 1, cs.getOrdinate(0, 1));
            }
            lines[part] = cs;
        }
        if (dimensions == 3) {
            buffer.position(buffer.position() + 16);
            for (part = 0; part < numParts; ++part) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                for (int i = 0; i < length; ++i) {
                    lines[part].setOrdinate(i, 2, buffer.getDouble());
                }
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int part2 = 0; part2 < numParts; ++part2) {
            lineStrings[part2] = this.geometryFactory.createLineString(lines[part2]);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    private void prepareCoordinateArrays(int numPoints) {
        if (this.x == null || this.x.length < numPoints) {
            this.x = new double[numPoints];
            this.y = new double[numPoints];
            this.z = new double[numPoints];
        }
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int ncoords;
        int lineN;
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        CoordinateSequence[] lines = new CoordinateSequence[numParts];
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        int npoints = multi.getNumPoints();
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        int idx = 0;
        for (int i = 0; i < numParts; ++i) {
            lines[i] = ((LineString)multi.getGeometryN(i)).getCoordinateSequence();
            buffer.putInt(idx);
            idx += lines[i].size();
        }
        for (lineN = 0; lineN < lines.length; ++lineN) {
            CoordinateSequence coords = lines[lineN];
            if (this.shapeType == ShapeType.ARCZ) {
                JTSUtilities.zMinMax(coords, zExtreame);
            }
            ncoords = coords.size();
            for (int t = 0; t < ncoords; ++t) {
                buffer.putDouble(coords.getX(t));
                buffer.putDouble(coords.getY(t));
            }
        }
        if (this.shapeType == ShapeType.ARCZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (lineN = 0; lineN < lines.length; ++lineN) {
                CoordinateSequence coords = lines[lineN];
                ncoords = coords.size();
                for (int t = 0; t < ncoords; ++t) {
                    double z = coords.getOrdinate(t, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                        continue;
                    }
                    buffer.putDouble(z);
                }
            }
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (int t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

