/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0.parsers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows10.ExceptionReportType;
import net.opengis.ows10.ExceptionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.protocol.wfs.WFSException;
import org.geotools.data.wfs.protocol.wfs.WFSResponse;
import org.geotools.data.wfs.protocol.wfs.WFSResponseParser;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_Protocol;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

public class ExceptionReportParser
implements WFSResponseParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");

    public Object parse(WFS_1_1_0_DataStore wfs, WFSResponse response) {
        Object parsed;
        WFSConfiguration configuration = new WFSConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        InputStream responseStream = response.getInputStream();
        Charset responseCharset = response.getCharacterEncoding();
        InputStreamReader reader = new InputStreamReader(responseStream, responseCharset);
        try {
            parsed = parser.parse((Reader)reader);
            if (!(parsed instanceof ExceptionReportType)) {
                return new IOException("Unrecognized server error");
            }
        }
        catch (Exception e) {
            return new WFSException("Exception parsing server exception report", e);
        }
        ExceptionReportType report = (ExceptionReportType)parsed;
        EList exceptions = report.getException();
        EObject originatingRequest = response.getOriginatingRequest();
        StringBuilder msg = new StringBuilder("WFS returned an exception.");
        msg.append(" Target URL: " + response.getTargetUrl());
        if (originatingRequest != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                WFS_1_1_0_Protocol.encode(originatingRequest, (Configuration)configuration, out, Charset.forName("UTF-8"));
                String requestStr = out.toString("UTF-8");
                msg.append(". Originating request is: \n").append(requestStr).append("\n");
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error encoding request for exception report", e);
            }
        }
        WFSException result = new WFSException(msg.toString());
        for (ExceptionType ex : exceptions) {
            result.addExceptionReport(String.valueOf(ex.getExceptionText()));
        }
        return result;
    }
}

