/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.wfs.v1_1_0.CapabilitiesResourceInfo;
import org.geotools.data.wfs.v1_1_0.WFSFeatureCollection;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSFeatureSource
implements FeatureSource<SimpleFeatureType, SimpleFeature> {
    private String typeName;
    private WFS_1_1_0_DataStore dataStore;
    private SimpleFeatureType featureType;
    private QueryCapabilities queryCapabilities;

    public WFSFeatureSource(WFS_1_1_0_DataStore dataStore, String typeName) throws IOException {
        this.typeName = typeName;
        this.dataStore = dataStore;
        this.queryCapabilities = new QueryCapabilities();
        this.featureType = dataStore.getSchema(typeName);
    }

    @Override
    public Name getName() {
        return this.featureType.getName();
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public ResourceInfo getInfo() {
        return new CapabilitiesResourceInfo(this.typeName, this.dataStore);
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.getInfo().getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        Query namedQuery = this.namedQuery(this.typeName, query);
        ReferencedEnvelope bounds = this.dataStore.getBounds(namedQuery);
        return bounds;
    }

    @Override
    public int getCount(Query query) throws IOException {
        Query namedQuery = this.namedQuery(this.typeName, query);
        int count = this.dataStore.getCount(namedQuery);
        return count;
    }

    public WFSFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.typeName, filter));
    }

    public WFSFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.typeName));
    }

    public WFSFeatureCollection getFeatures(Query query) throws IOException {
        Query namedQuery = this.namedQuery(this.typeName, query);
        return new WFSFeatureCollection(this.dataStore, namedQuery);
    }

    @Override
    public Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }

    private Query namedQuery(String typeName, Query query) {
        if (query.getTypeName() != null && !query.getTypeName().equals(typeName)) {
            throw new IllegalArgumentException("Wrong query type name: " + query.getTypeName() + ". It should be " + typeName);
        }
        DefaultQuery named = new DefaultQuery(query);
        named.setTypeName(typeName);
        return named;
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }
}

