/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.data.CatalogModeModel;
import org.geoserver.web.wicket.ParamResourceModel;

public class CatalogModePage
extends GeoServerSecuredPage {
    List<DataAccessManager.CatalogMode> CATALOG_MODES = Arrays.asList(DataAccessManager.CatalogMode.HIDE, DataAccessManager.CatalogMode.MIXED, DataAccessManager.CatalogMode.CHALLENGE);
    Form formCatalogMode;
    RadioChoice catalogMode;

    public CatalogModePage() {
        this.setModel((IModel)new CompoundPropertyModel((Object)new CatalogModeModel(DataAccessRuleDAO.get().getMode())));
        this.formCatalogMode = new Form("catalogModeForm");
        this.add((Component)this.formCatalogMode);
        this.catalogMode = new RadioChoice("catalogMode", this.CATALOG_MODES, (IChoiceRenderer)new CatalogModeRenderer());
        this.catalogMode.setSuffix(" ");
        this.formCatalogMode.add((Component)this.catalogMode);
        this.formCatalogMode.add((Component)new BookmarkablePageLink("cancel", GeoServerHomePage.class));
        this.formCatalogMode.add((Component)this.saveLink());
    }

    SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                this.onFormSubmit();
            }

            private void onFormSubmit() {
                try {
                    DataAccessRuleDAO dao = DataAccessRuleDAO.get();
                    DataAccessManager.CatalogMode newMode = DataAccessRuleDAO.getByAlias((String)CatalogModePage.this.catalogMode.getValue());
                    dao.setCatalogMode(newMode);
                    dao.storeRules();
                    this.setResponsePage(CatalogModePage.class);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
                    this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
                }
            }
        };
    }

    class CatalogModeRenderer
    implements IChoiceRenderer {
        CatalogModeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return (String)new ParamResourceModel(((DataAccessManager.CatalogMode)object).name(), (Component)CatalogModePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(Object object, int index) {
            return ((DataAccessManager.CatalogMode)object).name();
        }
    }
}

