/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.ServiceAccessRule;
import org.geoserver.security.ServiceAccessRuleDAO;
import org.geoserver.web.security.ConfirmRemovalServicePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionServiceRemovalLink
extends AjaxLink {
    GeoServerTablePanel<ServiceAccessRule> services;
    GeoServerDialog dialog;

    public SelectionServiceRemovalLink(String id, GeoServerTablePanel<ServiceAccessRule> services, GeoServerDialog dialog) {
        super(id);
        this.services = services;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.services.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                return new ConfirmRemovalServicePanel(id, selection){

                    protected StringResourceModel canRemove(ServiceAccessRule service) {
                        return SelectionServiceRemovalLink.this.canRemove(service);
                    }
                };
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                ServiceAccessRuleDAO dao = ServiceAccessRuleDAO.get();
                for (ServiceAccessRule service : selection) {
                    dao.removeRule((Comparable)service);
                }
                try {
                    dao.storeRules();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SelectionServiceRemovalLink.this.services.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionServiceRemovalLink.this.services.getSelection().size() == 0) {
                    SelectionServiceRemovalLink.this.setEnabled(false);
                    target.addComponent((Component)SelectionServiceRemovalLink.this);
                    target.addComponent(SelectionServiceRemovalLink.this.services);
                }
            }
        });
    }

    protected StringResourceModel canRemove(ServiceAccessRule service) {
        return null;
    }
}

