/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.gwc.GWCCleanser;
import org.geoserver.ows.Dispatcher;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSGeoServerHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.util.ApplicationContextProvider;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCCatalogListener
implements CatalogListener,
Configuration {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCCatalogListener");
    protected final Catalog cat;
    protected final Dispatcher gsDispatcher;
    protected final GridSetBroker gridSetBroker;
    protected final GWCCleanser cleanser;
    protected TileLayerDispatcher layerDispatcher;
    private List<String> mimeFormats = null;
    private int[] metaFactors = new int[]{4, 4};
    private String wmsUrl = null;
    ArrayList<TileLayer> list;

    public GWCCatalogListener(Catalog cat, Dispatcher gsDispatcher, GridSetBroker gridSetBroker, ApplicationContextProvider ctxProv, GWCCleanser cleanser) {
        this.cat = cat;
        this.gridSetBroker = gridSetBroker;
        this.gsDispatcher = gsDispatcher;
        this.cleanser = cleanser;
        this.mimeFormats = new ArrayList<String>(5);
        this.mimeFormats.add("image/png");
        this.mimeFormats.add("image/gif");
        this.mimeFormats.add("image/png8");
        this.mimeFormats.add("image/jpeg");
        this.mimeFormats.add("application/vnd.google-earth.kml+xml");
        cat.addListener((CatalogListener)this);
        log.fine("GWCCatalogListener registered with catalog");
    }

    public void setTileLayerDispatcher(TileLayerDispatcher layerDispatcher) {
        log.fine("TileLayerDispatcher was set");
        this.layerDispatcher = layerDispatcher;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        WMSLayer wmsLayer = null;
        if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            wmsLayer = this.getLayer(layerInfo);
        }
        if (wmsLayer != null && this.list != null) {
            this.addToList(wmsLayer);
            this.layerDispatcher.getLayers();
            this.layerDispatcher.add((TileLayer)wmsLayer);
            log.finer(wmsLayer.getName() + " added to TileLayerDispatcher");
        }
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof StyleInfoImpl) {
            StyleInfoImpl si = (StyleInfoImpl)obj;
            String styleName = si.getName();
            LinkedList<String> layerNameList = new LinkedList<String>();
            for (LayerInfo li : this.cat.getLayers()) {
                if (!li.getDefaultStyle().getName().equals(styleName)) continue;
                String prefixedName = li.getResource().getPrefixedName();
                layerNameList.add(prefixedName);
                this.cleanser.deleteLayer(prefixedName);
            }
            for (LayerGroupInfo lgi : this.cat.getLayerGroups()) {
                boolean truncate = false;
                Iterator liter = lgi.getLayers().iterator();
                while (!truncate && liter.hasNext()) {
                    LayerInfo li = (LayerInfo)liter.next();
                    if (!layerNameList.contains(li.getResource().getPrefixedName())) continue;
                    truncate = true;
                }
                if (!truncate) {
                    Iterator siiter = lgi.getStyles().iterator();
                    while (!truncate && siiter.hasNext()) {
                        StyleInfo si2 = (StyleInfo)siiter.next();
                        if (si2 == null || !si2.getName().equals(si.getName())) continue;
                        truncate = true;
                    }
                }
                if (!truncate) continue;
                this.cleanser.deleteLayer(lgi.getName());
            }
        } else {
            WMSLayer wmsLayer = null;
            if (obj instanceof LayerInfo) {
                LayerInfo li = (LayerInfo)obj;
                wmsLayer = this.getLayer(li);
            } else if (obj instanceof LayerGroupInfo) {
                LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
                wmsLayer = this.getLayer(lgInfo);
            }
            if (wmsLayer != null && this.list != null) {
                this.updateList(wmsLayer);
                this.layerDispatcher.getLayers();
                this.layerDispatcher.update((TileLayer)wmsLayer);
                log.finer(wmsLayer.getName() + " updated on TileLayerDispatcher");
                this.cleanser.deleteLayer(wmsLayer.getName());
            }
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        String prefixedName = null;
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            prefixedName = lgInfo.getName();
        } else if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            prefixedName = layerInfo.getResource().getPrefixedName();
        }
        if (null != prefixedName) {
            this.removeFromList(prefixedName);
            this.layerDispatcher.remove(prefixedName);
            this.cleanser.deleteLayer(prefixedName);
        }
    }

    public void reloaded() {
        try {
            this.layerDispatcher.reInit();
        }
        catch (GeoWebCacheException gwce) {
            log.fine("Unable to reinit TileLayerDispatcher gwce.getMessage()");
        }
    }

    public String getIdentifier() throws GeoWebCacheException {
        return "GeoServer Catalog Listener";
    }

    public ServiceInformation getServiceInformation() throws GeoWebCacheException {
        return null;
    }

    public List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        if (!reload && this.list != null) {
            return this.list;
        }
        this.list = new ArrayList(this.cat.getLayers().size());
        for (LayerInfo li : this.cat.getLayers()) {
            WMSLayer tl = this.getLayer(li.getResource());
            this.list.add((TileLayer)tl);
        }
        for (LayerGroupInfo lgi : this.cat.getLayerGroups()) {
            WMSLayer tl = this.getLayer(lgi);
            this.list.add((TileLayer)tl);
        }
        log.fine("Responding with " + this.list.size() + " to getTileLayers() request from TileLayerDispatcher");
        return this.list;
    }

    private synchronized void updateList(WMSLayer wmsLayer) {
        if (this.list != null) {
            this.removeFromList(wmsLayer);
            this.addToList(wmsLayer);
        }
    }

    private void removeFromList(WMSLayer wmsLayer) {
        this.removeFromList(wmsLayer.getName());
    }

    private synchronized void removeFromList(String layerName) {
        if (this.list != null) {
            Iterator<TileLayer> iter = this.list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                TileLayer tl = iter.next();
                if (tl != null && tl.getName().equals(layerName)) {
                    this.list.remove(i);
                    return;
                }
                ++i;
            }
            log.finer("Did not find " + layerName + " in list.");
        }
    }

    private synchronized void addToList(WMSLayer wmsLayer) {
        if (this.list != null) {
            this.list.add((TileLayer)wmsLayer);
        }
    }

    private WMSLayer getLayer(LayerInfo li) {
        return this.getLayer(li.getResource());
    }

    private WMSLayer getLayer(LayerGroupInfo lgi) {
        ReferencedEnvelope bounds = null;
        ReferencedEnvelope latLonBounds = null;
        String nativeSRSName = null;
        try {
            bounds = lgi.getBounds();
            nativeSRSName = "EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem(), (boolean)true);
            latLonBounds = lgi.getBounds().transform(CRS.decode((String)"EPSG:4326"), true);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        if (latLonBounds == null) {
            log.severe("GWCCatalogListener had problems getting or reprojecting " + lgi.getBounds() + " to EPSG:4326");
            return null;
        }
        WMSLayer retLayer = new WMSLayer(lgi.getName(), this.getWMSUrl(), null, lgi.getName(), this.mimeFormats, this.getGrids(lgi.getName(), latLonBounds, bounds, nativeSRSName), this.metaFactors, null, true);
        retLayer.setBackendTimeout(120);
        retLayer.setSourceHelper((WMSSourceHelper)new WMSGeoServerHelper(this.gsDispatcher));
        retLayer.initialize(this.gridSetBroker);
        return retLayer;
    }

    private WMSLayer getLayer(ResourceInfo fti) {
        ReferencedEnvelope nativeEnv = null;
        try {
            nativeEnv = fti.boundingBox();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WMSLayer retLayer = new WMSLayer(fti.getPrefixedName(), this.getWMSUrl(), null, fti.getPrefixedName(), this.mimeFormats, this.getGrids(fti.getPrefixedName(), fti.getLatLonBoundingBox(), nativeEnv, fti.getSRS()), this.metaFactors, null, true);
        retLayer.setBackendTimeout(120);
        retLayer.setSourceHelper((WMSSourceHelper)new WMSGeoServerHelper(this.gsDispatcher));
        retLayer.initialize(this.gridSetBroker);
        return retLayer;
    }

    private String[] getWMSUrl() {
        String[] strs = new String[]{this.wmsUrl};
        return strs;
    }

    private Hashtable<String, GridSubset> getGrids(String layerName, ReferencedEnvelope latLonEnv, ReferencedEnvelope nativeEnv, String nativeSRSName) {
        double minX = latLonEnv.getMinX();
        double minY = latLonEnv.getMinY();
        double maxX = latLonEnv.getMaxX();
        double maxY = latLonEnv.getMaxY();
        BoundingBox bounds4326 = new BoundingBox(minX, minY, maxX, maxY);
        BoundingBox bounds900913 = new BoundingBox(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
        Hashtable<String, GridSubset> grids = new Hashtable<String, GridSubset>(3);
        GridSubset gridSubset4326 = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.WORLD_EPSG4326, (BoundingBox)bounds4326, (Integer)0, (Integer)25);
        grids.put(this.gridSetBroker.WORLD_EPSG4326.getName(), gridSubset4326);
        GridSubset gridSubset900913 = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.WORLD_EPSG3857, (BoundingBox)bounds900913, (Integer)0, (Integer)25);
        grids.put(this.gridSetBroker.WORLD_EPSG3857.getName(), gridSubset900913);
        if (nativeSRSName != null && !nativeSRSName.equalsIgnoreCase("EPSG:4326")) {
            minX = nativeEnv.getMinX();
            minY = nativeEnv.getMinY();
            maxX = nativeEnv.getMaxX();
            maxY = nativeEnv.getMaxY();
            BoundingBox nativeBounds = new BoundingBox(minX, minY, maxX, maxY);
            SRS srs = null;
            try {
                srs = SRS.getSRS((String)nativeSRSName);
            }
            catch (GeoWebCacheException e) {
                e.printStackTrace();
            }
            String gridSetKey = nativeSRSName + "_" + layerName;
            GridSet gs = GridSetFactory.createGridSet((String)gridSetKey, (SRS)srs, (BoundingBox)nativeBounds, (boolean)false, (int)25, null, (double)2.8E-4, (int)256, (int)256);
            this.gridSetBroker.put(gs);
            GridSubset gsub = GridSubsetFactory.createGridSubSet((GridSet)gs, (BoundingBox)nativeBounds, (Integer)0, (Integer)24);
            grids.put(gridSetKey, gsub);
        }
        return grids;
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }
}

