/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.feature.CompositeFeatureCollection;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureCollectionTypeBinding
extends AbstractComplexEMFBinding {
    WfsFactory wfsfactory;
    Catalog catalog;
    boolean generateBounds;

    public FeatureCollectionTypeBinding(WfsFactory wfsfactory, Catalog catalog, Configuration configuration) {
        this.wfsfactory = wfsfactory;
        this.catalog = catalog;
        this.generateBounds = !configuration.getProperties().contains(GMLConfiguration.NO_FEATURE_BOUNDS);
    }

    public int getExecutionMode() {
        return 2;
    }

    public QName getTarget() {
        return WFS.FEATURECOLLECTIONTYPE;
    }

    public Class getType() {
        return FeatureCollectionType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (GML.featureMembers.equals(name)) {
            FeatureCollectionType featureCollection = (FeatureCollectionType)object;
            if (!featureCollection.getFeature().isEmpty()) {
                if (featureCollection.getFeature().size() > 1) {
                    return new CompositeFeatureCollection((List)featureCollection.getFeature());
                }
                return featureCollection.getFeature().iterator().next();
            }
        } else if (GML.boundedBy.equals(name) && this.generateBounds) {
            FeatureCollectionType featureCollection = (FeatureCollectionType)object;
            ReferencedEnvelope env = null;
            for (FeatureCollection fc : featureCollection.getFeature()) {
                if (env == null) {
                    env = fc.getBounds();
                } else {
                    env.expandToInclude((Envelope)fc.getBounds());
                }
                if (env != null && env.getCoordinateReferenceSystem() == null) {
                    FeatureTypeInfo info;
                    CoordinateReferenceSystem crs = fc.getSchema().getCoordinateReferenceSystem();
                    if (crs == null && (info = this.catalog.getFeatureTypeByName(fc.getSchema().getName())) != null) {
                        crs = info.getCRS();
                    }
                    env = new ReferencedEnvelope((Envelope)env, crs);
                }
                if (env == null) continue;
                return !env.isNull() && !env.isEmpty() ? env : null;
            }
        }
        return super.getProperty(object, name);
    }
}

