/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2OutputFormat
extends WFSGetFeatureOutputFormat {
    private static final int NO_FORMATTING = -1;
    private static final int INDENT_SIZE = 2;
    public static final String formatName = "GML2";
    public static final String formatNameCompressed = "GML2-GZIP";
    public static final String MIME_TYPE = "text/xml; subtype=gml/2.1.2";
    private FeatureTransformer transformer;
    private boolean compressOutput = false;
    private WFSInfo wfs;
    private GeoServer geoServer;
    protected Catalog catalog;

    public GML2OutputFormat(GeoServer geoServer) {
        super(new HashSet<String>(Arrays.asList(formatName, MIME_TYPE, formatNameCompressed)));
        this.wfs = (WFSInfo)geoServer.getService(WFSInfo.class);
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return MIME_TYPE;
    }

    public String getCapabilitiesElementName() {
        return formatName;
    }

    public void prepare(String outputFormat, FeatureCollectionType results, GetFeatureType request) throws IOException {
        this.compressOutput = formatNameCompressed.equalsIgnoreCase(outputFormat);
        this.transformer = this.createTransformer();
        FeatureTransformer.FeatureTypeNamespaces ftNames = this.transformer.getFeatureTypeNamespaces();
        HashMap<String, String> ftNamespaces = new HashMap<String, String>();
        int srs = -1;
        int numDecimals = -1;
        for (int i = 0; i < results.getFeature().size(); ++i) {
            String location;
            FeatureCollection features = (FeatureCollection)results.getFeature().get(i);
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(featureType.getName());
            String prefix = meta.getNamespace().getPrefix();
            String uri = meta.getNamespace().getURI();
            ftNames.declareNamespace(features.getSchema(), prefix, uri);
            if (ftNamespaces.containsKey(uri)) {
                location = (String)ftNamespaces.get(uri);
                ftNamespaces.put(uri, location + "," + meta.getName());
            } else {
                location = this.typeSchemaLocation(this.geoServer.getGlobal(), meta, request.getBaseUrl());
                ftNamespaces.put(uri, location);
            }
            QueryType query = (QueryType)request.getQuery().get(i);
            try {
                String srsName;
                String string = srsName = query.getSrsName() != null ? query.getSrsName().toString() : null;
                if (srsName == null) {
                    srsName = meta.getSRS();
                }
                if (srsName != null) {
                    CoordinateReferenceSystem crs = CRS.decode((String)srsName);
                    String epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)crs);
                    srs = Integer.parseInt(epsgCode);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem encoding:" + query.getSrsName(), e);
            }
            if (meta.getNumDecimals() <= 0) continue;
            numDecimals = numDecimals == -1 ? meta.getNumDecimals() : Math.max(numDecimals, meta.getNumDecimals());
        }
        GeoServerInfo global = this.geoServer.getGlobal();
        if (numDecimals == -1) {
            numDecimals = global.getNumDecimals();
        }
        this.transformer.setIndentation(this.wfs.isVerbose() ? 2 : -1);
        this.transformer.setNumDecimals(numDecimals);
        this.transformer.setFeatureBounding(this.wfs.isFeatureBounding());
        this.transformer.setCollectionBounding(this.wfs.isFeatureBounding());
        this.transformer.setEncoding(Charset.forName(global.getCharset()));
        if (this.wfs.isCanonicalSchemaLocation()) {
            this.transformer.addSchemaLocation("http://www.opengis.net/wfs", this.wfsCanonicalSchemaLocation());
        } else {
            String wfsSchemaloc = this.wfsSchemaLocation(global, request.getBaseUrl());
            this.transformer.addSchemaLocation("http://www.opengis.net/wfs", wfsSchemaloc);
        }
        for (String uri : ftNamespaces.keySet()) {
            this.transformer.addSchemaLocation(uri, (String)ftNamespaces.get(uri));
        }
        this.transformer.setGmlPrefixing(this.wfs.isCiteCompliant());
        if (results.getLockId() != null) {
            this.transformer.setLockId(results.getLockId());
        }
        if (srs != -1) {
            GMLInfo gml = this.wfs.getGML().get((Object)WFSInfo.Version.V_10);
            this.transformer.setSrsName(gml.getSrsNameStyle().getPrefix() + srs);
        }
    }

    public String getContentEncoding() {
        return this.compressOutput ? "gzip" : null;
    }

    public void encode(OutputStream output, FeatureCollectionType results, GetFeatureType request) throws ServiceException, IOException {
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GZIPOutputStream gzipOut = null;
        if (this.compressOutput) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        EList resultsList = results.getFeature();
        FeatureCollection[] featureResults = resultsList.toArray(new FeatureCollection[resultsList.size()]);
        try {
            this.transformer.transform((Object)featureResults, output);
            if (gzipOut != null) {
                gzipOut.finish();
                gzipOut.flush();
            }
        }
        catch (TransformerException gmlException) {
            String msg = " error:" + gmlException.getMessage();
            throw new ServiceException(msg, (Throwable)gmlException);
        }
    }

    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        GetFeatureType request = (GetFeatureType)getFeature.getParameters()[0];
        this.prepare(request.getOutputFormat(), featureCollection, request);
        this.encode(output, featureCollection, request);
    }

    protected FeatureTransformer createTransformer() {
        return new FeatureTransformer();
    }

    protected String wfsSchemaLocation(GeoServerInfo global, String baseUrl) {
        return ResponseUtils.buildSchemaURL((String)baseUrl, (String)"wfs/1.0.0/WFS-basic.xsd");
    }

    protected String wfsCanonicalSchemaLocation() {
        return "http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd";
    }

    protected String typeSchemaLocation(GeoServerInfo global, FeatureTypeInfo meta, String baseUrl) {
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.0.0", "request", "DescribeFeatureType", "typeName", meta.getPrefixedName()});
        return ResponseUtils.buildURL((String)baseUrl, (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }
}

