/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.adapters;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.XmlRequestReader;

public class XmlRequestReaderAdapter
extends XmlRequestReader
implements HttpServletRequestAware {
    Class delegateClass;
    ServiceInfo service;
    HttpServletRequest httpRequest;

    public XmlRequestReaderAdapter(QName element, ServiceInfo service, Class delegate) {
        super(element);
        this.service = service;
        this.delegateClass = delegate;
    }

    public XmlRequestReaderAdapter(String namespace, String local, ServiceInfo service, Class delegate) {
        this(new QName(namespace, local), service, delegate);
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.httpRequest = request;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Class<?> clazz = GeoServerImpl.unwrap(this.service).getClass();
        Constructor constructor = null;
        while (clazz != null && constructor == null) {
            try {
                constructor = this.delegateClass.getConstructor(clazz);
            }
            catch (NoSuchMethodException e) {
                Class<?>[] classes;
                for (Class<?> c : classes = clazz.getInterfaces()) {
                    try {
                        constructor = this.delegateClass.getConstructor(c);
                    }
                    catch (NoSuchMethodException e2) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("No appropriate constructor");
        }
        org.vfny.geoserver.util.requests.readers.XmlRequestReader delegate = (org.vfny.geoserver.util.requests.readers.XmlRequestReader)constructor.newInstance(this.service);
        return delegate.read(reader, this.httpRequest);
    }
}

