/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationProxy
implements InvocationHandler,
Serializable {
    Object proxyObject;
    transient ClassProperties cp;
    HashMap<String, Object> properties;

    public ModificationProxy(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    private ClassProperties cp() {
        if (this.cp == null) {
            this.cp = OwsUtils.getClassProperties(this.proxyObject.getClass());
        }
        return this.cp;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String property = null;
        if ((method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0) {
            property = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
            if (this.properties != null && this.properties().containsKey(property)) {
                return this.properties().get(property);
            }
            if (Collection.class.isAssignableFrom(method.getReturnType())) {
                Collection real = (Collection)method.invoke(this.proxyObject, null);
                if (real == null) {
                    return null;
                }
                Collection wrap = (Collection)real.getClass().newInstance();
                wrap.addAll(real);
                this.properties().put(property, wrap);
                return wrap;
            }
        }
        if (method.getName().startsWith("set") && args.length == 1) {
            property = method.getName().substring(3);
            this.properties().put(property, args[0]);
            return null;
        }
        try {
            Object o;
            Object result = method.invoke(this.proxyObject, args);
            if (result != null && this.shouldProxyProperty(result.getClass()) && (o = ModificationProxy.unwrap(result)) == result) {
                result = ModificationProxy.create(result, method.getReturnType());
                this.properties().put(property, result);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public HashMap<String, Object> getProperties() {
        return this.properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.proxyObject;
        synchronized (object) {
            for (Map.Entry<String, Object> e : this.properties().entrySet()) {
                String p = e.getKey();
                Object v = e.getValue();
                try {
                    Method g = this.getter(p);
                    if (Collection.class.isAssignableFrom(g.getReturnType())) {
                        Collection c = (Collection)g.invoke(this.proxyObject, null);
                        c.clear();
                        c.addAll((Collection)v);
                        continue;
                    }
                    Method s = this.setter(p, g.getReturnType());
                    if (Info.class.isAssignableFrom(g.getReturnType())) {
                        Info modified;
                        Info original = (Info)g.invoke(this.proxyObject, null);
                        if (original == (modified = (Info)ModificationProxy.unwrap(v))) {
                            ModificationProxy h;
                            if (!(v instanceof Proxy) || (h = ModificationProxy.handler(v)) == null || !h.isDirty()) continue;
                            h.commit();
                            continue;
                        }
                        if (s != null) {
                            s.invoke(this.proxyObject, v);
                            continue;
                        }
                        throw new IllegalStateException("New info object set, but no setter for it.");
                    }
                    s.invoke(this.proxyObject, v);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.properties = null;
        }
    }

    boolean shouldProxyProperty(Class propertyType) {
        if (Catalog.class.isAssignableFrom(propertyType)) {
            return false;
        }
        return Info.class.isAssignableFrom(propertyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> properties() {
        if (this.properties != null) {
            return this.properties;
        }
        ModificationProxy modificationProxy = this;
        synchronized (modificationProxy) {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public boolean isDirty() {
        boolean dirty = false;
        Iterator<Map.Entry<String, Object>> i = this.properties().entrySet().iterator();
        while (i.hasNext() && !dirty) {
            ModificationProxy h;
            Map.Entry<String, Object> e = i.next();
            if (e.getValue() instanceof Proxy && (h = ModificationProxy.handler(e.getValue())) != null && !h.isDirty()) continue;
            dirty = true;
        }
        return dirty;
    }

    List<String> getDirtyProperties() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (String propertyName : this.properties().keySet()) {
            ModificationProxy h;
            Object value = this.properties.get(propertyName);
            if (value instanceof Proxy && (h = ModificationProxy.handler(value)) != null && !h.isDirty()) {
                Object curr = ModificationProxy.unwrap(value);
                try {
                    Object orig = ModificationProxy.unwrap(this.getter(propertyName).invoke(this.proxyObject, null));
                    if (curr == orig) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    public List<String> getPropertyNames() {
        List<String> propertyNames = this.getDirtyProperties();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String name = propertyNames.get(i);
            propertyNames.set(i, Character.toLowerCase(name.charAt(0)) + name.substring(1));
        }
        return propertyNames;
    }

    public List<Object> getOldValues() {
        ArrayList<Object> oldValues = new ArrayList<Object>();
        for (String propertyName : this.getDirtyProperties()) {
            try {
                Method g = this.getter(propertyName);
                if (g == null) {
                    throw new IllegalArgumentException("No such property: " + propertyName);
                }
                oldValues.add(g.invoke(this.proxyObject, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return oldValues;
    }

    public List<Object> getNewValues() {
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (String propertyName : this.getDirtyProperties()) {
            newValues.add(this.properties().get(propertyName));
        }
        return newValues;
    }

    Method getter(String propertyName) {
        Method g = null;
        try {
            g = this.proxyObject.getClass().getMethod("get" + propertyName, null);
        }
        catch (NoSuchMethodException e1) {
            try {
                g = this.proxyObject.getClass().getMethod("is" + propertyName, null);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        if (g == null) {
            g = this.cp().getter(propertyName, null);
        }
        return g;
    }

    Method setter(String propertyName, Class type) {
        Method s = null;
        try {
            s = this.proxyObject.getClass().getMethod("set" + propertyName, type);
        }
        catch (NoSuchMethodException e) {
            s = this.cp().setter(propertyName, type);
        }
        return s;
    }

    public static <T> T create(T proxyObject, Class<T> clazz) {
        Object proxy;
        ModificationProxy h = new ModificationProxy(proxyObject);
        List<Class<?>> proxyInterfaces = Arrays.asList(proxyObject.getClass().getInterfaces());
        boolean add = true;
        for (Class<?> interfce : proxyObject.getClass().getInterfaces()) {
            if (!clazz.isAssignableFrom(interfce)) continue;
            add = false;
            break;
        }
        if (add) {
            proxyInterfaces = new ArrayList(proxyInterfaces);
            proxyInterfaces.add(clazz);
        }
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), proxyInterfaces.toArray(new Class[proxyInterfaces.size()]));
        try {
            proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)proxy;
    }

    public static <T> List<T> createList(List<T> proxyList, Class<T> clazz) {
        return new list<T>(proxyList, clazz);
    }

    public static <T> T unwrap(T object) {
        ModificationProxy h;
        if (object instanceof Proxy && (h = ModificationProxy.handler(object)) != null) {
            return (T)h.getProxyObject();
        }
        if (object instanceof ProxyList) {
            return (T)((ProxyList)object).proxyList;
        }
        return object;
    }

    public static ModificationProxy handler(Object object) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = Proxy.getInvocationHandler(object)) instanceof ModificationProxy) {
            return (ModificationProxy)h;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class list<T>
    extends ProxyList {
        list(List<T> list2, Class<T> clazz) {
            super(list2, clazz);
        }

        @Override
        protected <T> T createProxy(T proxyObject, Class<T> proxyInterface) {
            return ModificationProxy.create(proxyObject, proxyInterface);
        }

        protected <U> U unwrapProxy(U proxy, Class<U> proxyInterface) {
            return ModificationProxy.unwrap(proxy);
        }
    }
}

