/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.SharedResources;
import org.apache.wicket.util.resource.AbstractStringResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.TextTemplate;

public class TextTemplateSharedResourceFactory {
    private static final long serialVersionUID = 1L;
    private final WeakReference scopeRef;
    private final TextTemplate template;

    public TextTemplateSharedResourceFactory(TextTemplate template) {
        this(template, Application.class);
    }

    public TextTemplateSharedResourceFactory(TextTemplate template, Class scope) {
        this.template = template;
        this.scopeRef = new WeakReference<Class>(scope);
    }

    public ResourceReference resourceReference(Map variables) {
        String uniqueName = this.sharedResourceName(variables);
        final String templateValue = this.template.asString(variables);
        SharedResources sharedResources = Application.get().getSharedResources();
        Resource resource = sharedResources.get(uniqueName);
        if (resource == null) {
            Resource newResource = new Resource(){
                private static final long serialVersionUID = 1L;

                public IResourceStream getResourceStream() {
                    return new AbstractStringResourceStream(this){
                        private static final long serialVersionUID = 1L;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected String getString() {
                            return 1.access$000(this.this$1);
                        }

                        public long length() {
                            return Strings.lengthInBytes(this.getString(), this.getCharset());
                        }
                    };
                }

                static /* synthetic */ String access$000(1 x0) {
                    return x0.templateValue;
                }
            };
            sharedResources.add(uniqueName, newResource);
        }
        return new ResourceReference((Class)this.scopeRef.get(), uniqueName);
    }

    protected String sharedResourceName(Map variables) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = variables.values().iterator();
        while (iterator.hasNext()) {
            String value = iterator.next().toString();
            buffer.append(this.encodeValue(value));
            if (!iterator.hasNext()) continue;
            buffer.append('-');
        }
        return buffer.toString();
    }

    private String encodeValue(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 10);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append('%');
            buffer.append(Integer.toHexString(c));
        }
        return buffer.toString();
    }
}

