/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import org.apache.wicket.util.string.Strings;

public class ExtensionResourceNameIterator
implements Iterator {
    private final String path;
    private final String[] extensions;
    private int index;

    public ExtensionResourceNameIterator(String path, String extension) {
        if (extension == null) {
            this.extensions = new String[]{"." + Strings.lastPathComponent(path, '.')};
            path = Strings.beforeLastPathComponent(path, '.');
        } else {
            this.extensions = Strings.split(extension, ',');
            for (int i = this.extensions.length - 1; i >= 0; --i) {
                this.extensions[i] = this.extensions[i].trim();
                if (this.extensions[i].startsWith(".")) continue;
                this.extensions[i] = "." + this.extensions[i];
            }
        }
        this.path = path;
        this.index = 0;
    }

    public boolean hasNext() {
        return this.index < this.extensions.length;
    }

    public Object next() {
        return this.path + this.extensions[this.index++];
    }

    public void remove() {
    }
}

