/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import [Ljava.lang.Object;;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializableChecker
extends ObjectOutputStream {
    private static final Logger logger = LoggerFactory.getLogger((Class)SerializableChecker.class);
    private static final NoopOutputStream DUMMY_OUTPUT_STREAM = new NoopOutputStream();
    private static final Logger log = LoggerFactory.getLogger((Class)SerializableChecker.class);
    private static boolean available = true;
    private static Method LOOKUP_METHOD;
    private static Method GET_CLASS_DATA_LAYOUT_METHOD;
    private static Method GET_NUM_OBJ_FIELDS_METHOD;
    private static Method GET_OBJ_FIELD_VALUES_METHOD;
    private static Method GET_FIELD_METHOD;
    private static Method HAS_WRITE_REPLACE_METHOD_METHOD;
    private static Method INVOKE_WRITE_REPLACE_METHOD;
    private final LinkedList traceStack = new LinkedList();
    private final Map checked = new IdentityHashMap();
    private final LinkedList nameStack = new LinkedList();
    private Object root;
    private final Map writeObjectMethodCache = new HashMap();
    private String simpleName = "";
    private String fieldDescription;
    private final NotSerializableException exception;

    public static boolean isAvailable() {
        return available;
    }

    public SerializableChecker(NotSerializableException exception) throws IOException {
        this.exception = exception;
    }

    public void reset() throws IOException {
        this.root = null;
        this.checked.clear();
        this.fieldDescription = null;
        this.simpleName = null;
        this.traceStack.clear();
        this.nameStack.clear();
        this.writeObjectMethodCache.clear();
    }

    private void check(Object obj) {
        ObjectStreamClass desc;
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        this.nameStack.add(this.simpleName);
        this.traceStack.add(new TraceSlot(obj, this.fieldDescription));
        if (!(obj instanceof Serializable) && !Proxy.isProxyClass(cls)) {
            throw new WicketNotSerializableException(this.toPrettyPrintedStack(obj.getClass().getName()), this.exception);
        }
        try {
            Class<?> repCl;
            while (((Boolean)HAS_WRITE_REPLACE_METHOD_METHOD.invoke((Object)(desc = (ObjectStreamClass)LOOKUP_METHOD.invoke(null, cls, Boolean.TRUE)), null)).booleanValue() && (obj = INVOKE_WRITE_REPLACE_METHOD.invoke((Object)desc, obj)) != null && (repCl = obj.getClass()) != cls) {
                cls = repCl;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (!cls.isPrimitive()) {
            if (cls.isArray()) {
                this.checked.put(obj, null);
                Class<?> ccl = cls.getComponentType();
                if (!ccl.isPrimitive()) {
                    Object[] objs = (Object[])obj;
                    for (int i = 0; i < objs.length; ++i) {
                        String arrayPos;
                        this.simpleName = arrayPos = "[" + i + "]";
                        this.fieldDescription = this.fieldDescription + arrayPos;
                        this.check(objs[i]);
                    }
                }
            } else if (obj instanceof Externalizable && !Proxy.isProxyClass(cls)) {
                Externalizable extObj = (Externalizable)obj;
                try {
                    extObj.writeExternal(new ObjectOutputAdaptor(){
                        private int count = 0;

                        public void writeObject(Object streamObj) throws IOException {
                            if (SerializableChecker.this.checked.containsKey(streamObj)) {
                                return;
                            }
                            SerializableChecker.this.checked.put(streamObj, null);
                            String arrayPos = "[write:" + this.count++ + "]";
                            SerializableChecker.this.simpleName = arrayPos;
                            SerializableChecker.this.fieldDescription = SerializableChecker.this.fieldDescription + arrayPos;
                            SerializableChecker.this.check(streamObj);
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof WicketNotSerializableException) {
                        throw (WicketNotSerializableException)e;
                    }
                    log.warn("error delegating to Externalizable : " + e.getMessage() + ", path: " + this.currentPath());
                }
            } else {
                Method writeObjectMethod = null;
                Object o = this.writeObjectMethodCache.get(cls);
                if (o != null) {
                    if (o instanceof Method) {
                        writeObjectMethod = (Method)o;
                    }
                } else {
                    try {
                        writeObjectMethod = cls.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                    }
                    catch (SecurityException e) {
                        this.writeObjectMethodCache.put(cls, Boolean.FALSE);
                    }
                    catch (NoSuchMethodException e) {
                        this.writeObjectMethodCache.put(cls, Boolean.FALSE);
                    }
                }
                Object original = obj;
                if (writeObjectMethod != null) {
                    try {
                        class InterceptingObjectOutputStream
                        extends ObjectOutputStream {
                            private int counter;
                            private final /* synthetic */ Object val$original;

                            InterceptingObjectOutputStream(Object val$original) throws IOException {
                                this.val$original = val$original;
                                super(DUMMY_OUTPUT_STREAM);
                                this.enableReplaceObject(true);
                            }

                            protected Object replaceObject(Object streamObj) throws IOException {
                                if (streamObj == this.val$original) {
                                    return streamObj;
                                }
                                ++this.counter;
                                if (SerializableChecker.this.checked.containsKey(streamObj)) {
                                    return null;
                                }
                                SerializableChecker.this.checked.put(this.val$original, null);
                                String arrayPos = "[write:" + this.counter + "]";
                                SerializableChecker.this.simpleName = arrayPos;
                                SerializableChecker.this.fieldDescription = SerializableChecker.this.fieldDescription + arrayPos;
                                SerializableChecker.this.check(streamObj);
                                return streamObj;
                            }
                        }
                        InterceptingObjectOutputStream ioos = new InterceptingObjectOutputStream(original);
                        ioos.writeObject(obj);
                    }
                    catch (Exception e) {
                        if (e instanceof WicketNotSerializableException) {
                            throw (WicketNotSerializableException)e;
                        }
                        log.warn("error delegating to writeObject : " + e.getMessage() + ", path: " + this.currentPath());
                    }
                } else {
                    Object[] slots;
                    try {
                        slots = (Object[])GET_CLASS_DATA_LAYOUT_METHOD.invoke((Object)desc, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    for (int i = 0; i < slots.length; ++i) {
                        ObjectStreamClass slotDesc;
                        try {
                            Field descField = slots[i].getClass().getDeclaredField("desc");
                            descField.setAccessible(true);
                            slotDesc = (ObjectStreamClass)descField.get(slots[i]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.checked.put(obj, null);
                        this.checkFields(obj, slotDesc);
                    }
                }
            }
        }
        this.traceStack.removeLast();
        this.nameStack.removeLast();
    }

    private void checkFields(Object obj, ObjectStreamClass desc) {
        int numFields;
        try {
            numFields = (Integer)GET_NUM_OBJ_FIELDS_METHOD.invoke((Object)desc, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (numFields > 0) {
            ObjectStreamField[] fields = desc.getFields();
            Object[] objVals = new Object[numFields];
            int numPrimFields = fields.length - objVals.length;
            try {
                GET_OBJ_FIELD_VALUES_METHOD.invoke((Object)desc, obj, objVals);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < objVals.length; ++i) {
                Field field;
                if (objVals[i] instanceof String || objVals[i] instanceof Number || objVals[i] instanceof Date || objVals[i] instanceof Boolean || objVals[i] instanceof Class || this.checked.containsKey(objVals[i])) continue;
                ObjectStreamField fieldDesc = fields[numPrimFields + i];
                try {
                    field = (Field)GET_FIELD_METHOD.invoke((Object)fieldDesc, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                String fieldName = field.getName();
                this.simpleName = field.getName();
                this.fieldDescription = field.toString();
                this.check(objVals[i]);
            }
        }
    }

    private StringBuffer currentPath() {
        StringBuffer b = new StringBuffer();
        Iterator it = this.nameStack.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append('/');
        }
        return b;
    }

    private final String toPrettyPrintedStack(String type) {
        StringBuffer result = new StringBuffer();
        StringBuffer spaces = new StringBuffer();
        result.append("Unable to serialize class: ");
        result.append(type);
        result.append("\nField hierarchy is:");
        ListIterator i = this.traceStack.listIterator();
        while (i.hasNext()) {
            spaces.append("  ");
            TraceSlot slot = (TraceSlot)i.next();
            result.append("\n").append(spaces).append(slot.fieldDescription);
            result.append(" [class=").append(slot.object.getClass().getName());
            if (slot.object instanceof Component) {
                Component component = (Component)slot.object;
                result.append(", path=").append(component.getPath());
            }
            result.append("]");
        }
        result.append(" <----- field that is not serializable");
        return result.toString();
    }

    protected final void writeObjectOverride(Object obj) throws IOException {
        if (!available) {
            return;
        }
        this.root = obj;
        if (this.fieldDescription == null) {
            this.fieldDescription = this.root instanceof Component ? ((Component)this.root).getPath() : "";
        }
        this.check(this.root);
    }

    static {
        try {
            LOOKUP_METHOD = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
            LOOKUP_METHOD.setAccessible(true);
            GET_CLASS_DATA_LAYOUT_METHOD = ObjectStreamClass.class.getDeclaredMethod("getClassDataLayout", null);
            GET_CLASS_DATA_LAYOUT_METHOD.setAccessible(true);
            GET_NUM_OBJ_FIELDS_METHOD = ObjectStreamClass.class.getDeclaredMethod("getNumObjFields", null);
            GET_NUM_OBJ_FIELDS_METHOD.setAccessible(true);
            GET_OBJ_FIELD_VALUES_METHOD = ObjectStreamClass.class.getDeclaredMethod("getObjFieldValues", Object.class, Object;.class);
            GET_OBJ_FIELD_VALUES_METHOD.setAccessible(true);
            GET_FIELD_METHOD = ObjectStreamField.class.getDeclaredMethod("getField", null);
            GET_FIELD_METHOD.setAccessible(true);
            HAS_WRITE_REPLACE_METHOD_METHOD = ObjectStreamClass.class.getDeclaredMethod("hasWriteReplaceMethod", null);
            HAS_WRITE_REPLACE_METHOD_METHOD.setAccessible(true);
            INVOKE_WRITE_REPLACE_METHOD = ObjectStreamClass.class.getDeclaredMethod("invokeWriteReplace", Object.class);
            INVOKE_WRITE_REPLACE_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            logger.warn("SerializableChecker not available", (Throwable)e);
            available = false;
        }
    }

    private static final class TraceSlot {
        private final String fieldDescription;
        private final Object object;

        TraceSlot(Object object, String fieldDescription) {
            this.object = object;
            this.fieldDescription = fieldDescription;
        }

        public String toString() {
            return this.object.getClass() + " - " + this.fieldDescription;
        }
    }

    private static abstract class ObjectOutputAdaptor
    implements ObjectOutput {
        private ObjectOutputAdaptor() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void write(int b) throws IOException {
        }

        public void writeBoolean(boolean v) throws IOException {
        }

        public void writeByte(int v) throws IOException {
        }

        public void writeBytes(String s) throws IOException {
        }

        public void writeChar(int v) throws IOException {
        }

        public void writeChars(String s) throws IOException {
        }

        public void writeDouble(double v) throws IOException {
        }

        public void writeFloat(float v) throws IOException {
        }

        public void writeInt(int v) throws IOException {
        }

        public void writeLong(long v) throws IOException {
        }

        public void writeShort(int v) throws IOException {
        }

        public void writeUTF(String str) throws IOException {
        }
    }

    private static class NoopOutputStream
    extends OutputStream {
        private NoopOutputStream() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int i, int l) {
        }

        public void write(int b) {
        }
    }

    public static final class WicketNotSerializableException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        WicketNotSerializableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

