/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;

final class HandleArrayListStack
extends ArrayList {
    private static final long serialVersionUID = 1L;

    public HandleArrayListStack() {
        this(10);
    }

    public HandleArrayListStack(Collection collection) {
        super(collection);
    }

    public HandleArrayListStack(int initialCapacity) {
        super(initialCapacity);
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public int indexOf(Object elem) {
        int size = this.size();
        if (elem == null) {
            for (int i = 0; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (elem != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (elem != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public final Object peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.get(size - 1);
    }

    public final Object pop() {
        Object top = this.peek();
        this.remove(this.size() - 1);
        return top;
    }

    public final void push(Object item) {
        this.add(item);
    }

    public final int search(Object o) {
        int i = this.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }
}

