/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.util.Locale;
import org.apache.wicket.util.convert.converters.AbstractIntegerConverter;

public class ZeroPaddingIntegerConverter
extends AbstractIntegerConverter {
    private static final long serialVersionUID = 1L;
    private final int zeroPadLength;

    public ZeroPaddingIntegerConverter(int zeroPadLength) {
        this.zeroPadLength = zeroPadLength;
    }

    public String convertToString(Object value, Locale locale) {
        String result = super.convertToString(value, locale);
        while (result.length() < this.zeroPadLength) {
            result = "0" + result;
        }
        return result;
    }

    public Object convertToObject(String value, Locale locale) {
        Number number = this.parse(value, -2.147483648E9, 2.147483647E9, locale);
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    protected Class getTargetType() {
        return Integer.class;
    }
}

