/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.model.IPropertyReflectionAwareModel;
import org.apache.wicket.util.lang.PropertyResolver;
import org.apache.wicket.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractPropertyModel
implements IChainingModel,
IObjectClassAwareModel,
IPropertyReflectionAwareModel {
    private static final long serialVersionUID = 1L;
    private Object target;

    public AbstractPropertyModel(Object modelObject) {
        if (modelObject == null) {
            throw new IllegalArgumentException("Parameter modelObject cannot be null");
        }
        this.target = modelObject;
    }

    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    public IModel getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    public Object getObject() {
        String expression = this.propertyExpression();
        if (Strings.isEmpty(expression)) {
            return this.getTarget();
        }
        Object target = this.getTarget();
        if (target != null) {
            return PropertyResolver.getValue(expression, target);
        }
        return null;
    }

    public final String getPropertyExpression() {
        return this.propertyExpression();
    }

    public void setChainedModel(IModel model) {
        this.target = model;
    }

    public void setObject(Object object) {
        String expression = this.propertyExpression();
        if (Strings.isEmpty(expression)) {
            if (this.target instanceof IModel) {
                ((IModel)this.target).setObject(object);
            } else {
                this.target = object;
            }
        } else {
            PropertyResolverConverter prc = null;
            prc = new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
            PropertyResolver.setValue(expression, this.getTarget(), object, prc);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Model:classname=[");
        sb.append(this.getClass().getName()).append("]");
        sb.append(":nestedModel=[").append(this.target).append("]");
        return sb.toString();
    }

    public final Object getTarget() {
        Object tmp;
        Object object = this.target;
        while (object instanceof IModel && (tmp = ((IModel)object).getObject()) != object) {
            object = tmp;
        }
        return object;
    }

    public Class getObjectClass() {
        String expression = this.propertyExpression();
        if (Strings.isEmpty(expression)) {
            Object target = this.getTarget();
            return target != null ? target.getClass() : null;
        }
        Object target = this.getTarget();
        if (target != null) {
            try {
                return PropertyResolver.getPropertyClass(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Field getPropertyField() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertyField(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Method getPropertyGetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertyGetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Method getPropertySetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty(expression) && (target = this.getTarget()) != null) {
            try {
                return PropertyResolver.getPropertySetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract String propertyExpression();

    protected final Object onGetObject(Component component) {
        throw new UnsupportedOperationException();
    }

    protected final void onSetObject(Component component, Object object) {
        throw new UnsupportedOperationException();
    }
}

