/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.transformer.ITransformer;
import org.apache.wicket.response.StringResponse;

public abstract class AbstractTransformerBehavior
extends AbstractBehavior
implements ITransformer {
    private static final long serialVersionUID = 1L;
    private Response webResponse;

    protected Response newResponse() {
        return new StringResponse();
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        tag.put("xmlns:wicket", "http://wicket.apache.org");
        RequestCycle requestCycle = RequestCycle.get();
        this.webResponse = requestCycle.getResponse();
        Response response = this.newResponse();
        if (response == null) {
            throw new IllegalStateException("newResponse() must not return null");
        }
        requestCycle.setResponse(response);
    }

    public void onRendered(Component component) {
        RequestCycle requestCycle = RequestCycle.get();
        try {
            Response response = requestCycle.getResponse();
            CharSequence output = this.transform(component, response.toString());
            this.webResponse.write(output);
        }
        catch (Exception ex) {
            throw new WicketRuntimeException("Error while transforming the output: " + this, ex);
        }
        finally {
            requestCycle.setResponse(this.webResponse);
        }
    }

    public void cleanup() {
        this.webResponse = null;
    }

    public void onException(Component component, RuntimeException exception) {
        if (this.webResponse != null) {
            RequestCycle requestCycle = RequestCycle.get();
            requestCycle.setResponse(this.webResponse);
        }
    }

    public abstract CharSequence transform(Component var1, CharSequence var2) throws Exception;
}

