/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class WicketLinkTagHandler
extends AbstractMarkupFilter {
    public static final String AUTOLINK_ID = "_autolink_";
    private ArrayListStack autolinkStatus;
    private boolean autolinking = true;

    public WicketLinkTagHandler() {
        this.setAutomaticLinking(Application.get().getMarkupSettings().getAutomaticLinking());
    }

    public void setAutomaticLinking(boolean enable) {
        this.autolinking = enable;
    }

    public final MarkupElement nextTag() throws ParseException {
        WicketTag wtag;
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag == null) {
            return tag;
        }
        if (this.autolinking && this.analyzeAutolinkCondition(tag)) {
            tag.enableAutolink(true);
            tag.setId(AUTOLINK_ID);
            tag.setAutoComponentTag(true);
            tag.setModified(true);
            return tag;
        }
        if (tag instanceof WicketTag && (wtag = (WicketTag)tag).isLinkTag()) {
            if (tag.isOpen() || tag.isOpenClose()) {
                if (tag.isOpen()) {
                    if (this.autolinkStatus == null) {
                        this.autolinkStatus = new ArrayListStack();
                    }
                    this.autolinkStatus.push(this.autolinking);
                }
                String autolink = tag.getAttributes().getString("autolink");
                try {
                    this.autolinking = Strings.isEmpty(autolink) || Strings.isTrue(autolink);
                }
                catch (StringValueConversionException e) {
                    throw new WicketRuntimeException("Invalid autolink attribute value \"" + autolink + "\"");
                }
            } else if (tag.isClose()) {
                this.autolinking = (Boolean)this.autolinkStatus.pop();
            }
            return wtag;
        }
        return tag;
    }

    protected boolean analyzeAutolinkCondition(ComponentTag tag) {
        if (tag.getId() == null) {
            IValueMap attributes = tag.getAttributes();
            String ref = attributes.getString("href");
            if (this.checkRef(ref)) {
                return true;
            }
            ref = attributes.getString("src");
            if (this.checkRef(ref)) {
                return true;
            }
        }
        return false;
    }

    private final boolean checkRef(String ref) {
        return ref != null && ref.indexOf(":") == -1;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("link");
    }
}

