/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public class OpenCloseTagExpander
extends AbstractMarkupFilter {
    ComponentTag next = null;
    private static final List replaceForTags = Arrays.asList("div", "span", "p", "strong", "b", "e");

    public MarkupElement nextTag() throws ParseException {
        if (this.next != null) {
            ComponentTag tmp = this.next;
            this.next = null;
            return tmp;
        }
        ComponentTag tag = this.nextComponentTag();
        if (tag != null && tag.isOpenClose() && replaceForTags.contains(tag.getName().toLowerCase())) {
            tag.setType(XmlTag.OPEN);
            if (tag.getId() == null) {
                tag.setId("_message_attr_");
                tag.setAutoComponentTag(true);
            }
            this.next = new ComponentTag(tag.getName(), XmlTag.CLOSE);
            this.next.setNamespace(tag.getNamespace());
            this.next.setOpenTag(tag);
        }
        return tag;
    }
}

