/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.io.FullyBufferedReader;
import org.apache.wicket.util.io.XmlReader;
import org.apache.wicket.util.parse.metapattern.parsers.TagNameParser;
import org.apache.wicket.util.parse.metapattern.parsers.VariableAssignmentParser;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public final class XmlPullParser
extends AbstractMarkupFilter
implements IXmlPullParser {
    public static final int NOT_INITIALIZED = 0;
    public static final int TAG = 1;
    public static final int BODY = 2;
    public static final int COMMENT = 3;
    public static final int CDATA = 4;
    public static final int PROCESSING_INSTRUCTION = 5;
    public static final int SPECIAL_TAG = 6;
    private XmlReader xmlReader;
    private FullyBufferedReader input;
    private String skipUntilText;
    private CharSequence lastText;
    private int lastType = 0;
    private XmlTag lastTag;

    public String getEncoding() {
        return this.xmlReader.getEncoding();
    }

    public String getXmlDeclaration() {
        return this.xmlReader.getXmlDeclaration();
    }

    public final CharSequence getInputFromPositionMarker(int toPos) {
        return this.input.getSubstring(toPos);
    }

    public final CharSequence getInput(int fromPos, int toPos) {
        return this.input.getSubstring(fromPos, toPos);
    }

    private final void skipUntil() throws ParseException {
        int startIndex = this.input.getPosition();
        int tagNameLen = this.skipUntilText.length();
        int pos = this.input.getPosition() - 1;
        String endTagText = null;
        int lastPos = 0;
        while (!this.skipUntilText.equalsIgnoreCase(endTagText)) {
            if ((pos = this.input.find("</", pos + 1)) == -1 || pos + (tagNameLen + 2) >= this.input.size()) {
                throw new ParseException(this.skipUntilText + " tag not closed (line " + this.input.getLineNumber() + ", column " + this.input.getColumnNumber() + ")", startIndex);
            }
            lastPos = pos + 2;
            endTagText = ((Object)this.input.getSubstring(lastPos, lastPos + tagNameLen)).toString();
        }
        this.input.setPosition(pos);
        this.lastText = this.input.getSubstring(startIndex, pos);
        this.lastType = 2;
        lastPos = this.input.find('>', lastPos + tagNameLen);
        if (lastPos == -1) {
            throw new ParseException("Script tag not closed (line " + this.input.getLineNumber() + ", column " + this.input.getColumnNumber() + ")", startIndex);
        }
        this.skipUntilText = null;
    }

    public final boolean next() throws ParseException {
        XmlTag.Type type;
        if (this.input.getPosition() >= this.input.size()) {
            return false;
        }
        if (this.skipUntilText != null) {
            this.skipUntil();
            return true;
        }
        int openBracketIndex = this.input.find('<');
        if (this.input.charAt(this.input.getPosition()) != '<') {
            if (openBracketIndex == -1) {
                this.lastText = this.input.getSubstring(-1);
                this.input.setPosition(this.input.size());
                this.lastType = 2;
                return true;
            }
            this.lastText = this.input.getSubstring(openBracketIndex);
            this.input.setPosition(openBracketIndex);
            this.lastType = 2;
            return true;
        }
        this.input.countLinesTo(openBracketIndex);
        int closeBracketIndex = this.input.find('>', openBracketIndex + 1);
        if (closeBracketIndex == -1) {
            throw new ParseException("No matching close bracket at position " + openBracketIndex, this.input.getPosition());
        }
        this.lastText = this.input.getSubstring(openBracketIndex, closeBracketIndex + 1);
        String tagText = ((Object)this.lastText.subSequence(1, this.lastText.length() - 1)).toString();
        if (tagText.length() == 0) {
            throw new ParseException("Found empty tag: '<>' at position " + openBracketIndex, this.input.getPosition());
        }
        char firstChar = tagText.charAt(0);
        if (firstChar == '!' || firstChar == '?') {
            this.specialTagHandling(tagText, openBracketIndex, closeBracketIndex);
            return true;
        }
        if (tagText.endsWith("/")) {
            type = XmlTag.OPEN_CLOSE;
            tagText = tagText.substring(0, tagText.length() - 1);
        } else if (tagText.startsWith("/")) {
            type = XmlTag.CLOSE;
            tagText = tagText.substring(1);
        } else {
            type = XmlTag.OPEN;
            if (tagText.length() > 5 && (tagText.charAt(0) == 's' || tagText.charAt(0) == 'S')) {
                String lowerCase = tagText.substring(0, 6).toLowerCase();
                if (lowerCase.startsWith("script")) {
                    this.skipUntilText = "script";
                } else if (lowerCase.startsWith("style")) {
                    this.skipUntilText = "style";
                }
            }
        }
        this.lastTag = this.parseTagText(tagText);
        if (this.lastTag != null) {
            this.lastTag.type = type;
            this.lastTag.pos = openBracketIndex;
            this.lastTag.length = this.lastText.length();
            this.lastTag.text = this.lastText;
            this.lastTag.lineNumber = this.input.getLineNumber();
            this.lastTag.columnNumber = this.input.getColumnNumber();
            this.input.setPosition(closeBracketIndex + 1);
            this.lastType = 1;
            return true;
        }
        throw new ParseException("Malformed tag (line " + this.input.getLineNumber() + ", column " + this.input.getColumnNumber() + ")", openBracketIndex);
    }

    private void specialTagHandling(String tagText, int openBracketIndex, int closeBracketIndex) throws ParseException {
        if (tagText.startsWith("!--")) {
            int pos = this.input.find("-->", openBracketIndex + 1);
            if (pos == -1) {
                throw new ParseException("Unclosed comment beginning at line:" + this.input.getLineNumber() + " column:" + this.input.getColumnNumber(), openBracketIndex);
            }
            this.lastText = this.input.getSubstring(openBracketIndex, pos += 3);
            this.lastType = 3;
            if (tagText.startsWith("!--[if ") && tagText.endsWith("]") && ((Object)this.lastText).toString().endsWith("<![endif]-->")) {
                this.input.setPosition(closeBracketIndex + 1);
            } else {
                this.input.setPosition(pos);
            }
            return;
        }
        if (tagText.equals("![endif]--")) {
            this.lastType = 3;
            this.input.setPosition(closeBracketIndex + 1);
            return;
        }
        if (tagText.startsWith("![")) {
            String startText;
            String string = startText = tagText.length() <= 8 ? tagText : tagText.substring(0, 8);
            if (startText.toUpperCase().equals("![CDATA[")) {
                int pos1 = openBracketIndex;
                do {
                    if ((closeBracketIndex = this.findChar('>', pos1)) == -1) {
                        throw new ParseException("No matching close bracket at line:" + this.input.getLineNumber() + " column:" + this.input.getColumnNumber(), this.input.getPosition());
                    }
                    tagText = ((Object)this.input.getSubstring(openBracketIndex + 1, closeBracketIndex)).toString();
                    pos1 = closeBracketIndex + 1;
                } while (!tagText.endsWith("]]"));
                this.input.setPosition(closeBracketIndex + 1);
                this.lastText = tagText;
                this.lastType = 4;
                return;
            }
        }
        if (tagText.charAt(0) == '?') {
            this.lastType = 5;
            this.input.setPosition(closeBracketIndex + 1);
            return;
        }
        this.lastType = 6;
        this.input.setPosition(closeBracketIndex + 1);
    }

    public final MarkupElement nextTag() throws ParseException {
        while (this.next()) {
            switch (this.lastType) {
                case 1: {
                    return this.lastTag;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        return null;
    }

    private int findChar(char ch, int startIndex) {
        char quote = '\u0000';
        while (startIndex < this.input.size()) {
            char charAt = this.input.charAt(startIndex);
            if (quote != '\u0000') {
                if (quote == charAt) {
                    quote = '\u0000';
                }
            } else if (charAt == '\"' || charAt == '\'') {
                quote = charAt;
            } else if (charAt == ch) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public void parse(CharSequence string) throws IOException, ResourceStreamNotFoundException {
        this.parse(new ByteArrayInputStream(((Object)string).toString().getBytes()), null);
    }

    public void parse(InputStream in) throws IOException, ResourceStreamNotFoundException {
        this.parse(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, String encoding) throws IOException, ResourceStreamNotFoundException {
        try {
            this.xmlReader = new XmlReader(new BufferedInputStream(inputStream, 4000), encoding);
            this.input = new FullyBufferedReader(this.xmlReader);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            if (this.xmlReader != null) {
                this.xmlReader.close();
            }
            throw throwable;
        }
        inputStream.close();
        if (this.xmlReader != null) {
            this.xmlReader.close();
        }
    }

    public final void setPositionMarker() {
        this.input.setPositionMarker(this.input.getPosition());
    }

    public final void setPositionMarker(int pos) {
        this.input.setPositionMarker(pos);
    }

    public String toString() {
        return this.input.toString();
    }

    private XmlTag parseTagText(String tagText) throws ParseException {
        int tagTextLength = tagText.length();
        TagNameParser tagnameParser = new TagNameParser(tagText);
        if (tagnameParser.matcher().lookingAt()) {
            XmlTag tag = new XmlTag();
            tag.name = tagnameParser.getName();
            tag.namespace = tagnameParser.getNamespace();
            int pos = tagnameParser.matcher().end(0);
            if (pos == tagTextLength) {
                return tag;
            }
            VariableAssignmentParser attributeParser = new VariableAssignmentParser(tagText);
            while (attributeParser.matcher().find(pos)) {
                String value = attributeParser.getValue();
                if (value == null) {
                    value = "";
                }
                pos = attributeParser.matcher().end(0);
                if (value.startsWith("\"") || value.startsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                value = value.trim();
                String key = attributeParser.getKey();
                if (null != tag.put(key, value)) {
                    throw new ParseException("Same attribute found twice: " + key, this.input.getPosition());
                }
                if (pos != tagTextLength) continue;
                return tag;
            }
            return tag;
        }
        return null;
    }
}

