/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.resources;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PackagedResourceReference
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$java$lang$String;

    public PackagedResourceReference(String id, Class referer, String file, String attributeToReplace) {
        this(id, referer, new Model((Serializable)((Object)file)), attributeToReplace);
    }

    public PackagedResourceReference(String id, final Class referer, final IModel file, String attributeToReplace) {
        super(id);
        if (referer == null) {
            throw new IllegalArgumentException("Referer may not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (attributeToReplace == null) {
            throw new IllegalArgumentException("AttributeToReplace may not be null");
        }
        Model srcReplacement = new Model(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                Object o = file.getObject();
                if (o == null) {
                    throw new IllegalArgumentException("The model must provide a non-null object");
                }
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The model must provide a string");
                }
                String f = PackagedResourceReference.this.getConverter(class$java$lang$String == null ? (class$java$lang$String = PackagedResourceReference.class$("java.lang.String")) : class$java$lang$String).convertToString(o, PackagedResourceReference.this.getLocale());
                ResourceReference ref = new ResourceReference(referer, f, PackagedResourceReference.this.getLocale(), PackagedResourceReference.this.getStyle());
                return PackagedResourceReference.this.urlFor(ref);
            }
        };
        this.add(new AttributeModifier(attributeToReplace, true, (IModel)srcReplacement));
    }

    protected ResourceReference createPackageResourceReference(Application app, Class scope, String name) {
        ResourceReference resourceReference = new ResourceReference(scope, name);
        resourceReference.bind(app);
        return resourceReference;
    }

    public PackagedResourceReference(String id, ResourceReference resourceReference, String attributeToReplace) {
        this(id, new Model(resourceReference), attributeToReplace);
    }

    public PackagedResourceReference(String id, final IModel resourceReference, String attributeToReplace) {
        super(id);
        if (resourceReference == null) {
            throw new IllegalArgumentException("ResourceReference may not be null");
        }
        if (attributeToReplace == null) {
            throw new IllegalArgumentException("AttributeToReplace may not be null");
        }
        Model srcReplacement = new Model(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                Object o = resourceReference.getObject();
                if (o == null) {
                    throw new IllegalArgumentException("The model must provide a non-null object");
                }
                if (!(o instanceof ResourceReference)) {
                    throw new IllegalArgumentException("The model must provide an instance of ResourceReference");
                }
                ResourceReference ref = (ResourceReference)o;
                return PackagedResourceReference.this.urlFor(ref);
            }
        };
        this.add(new AttributeModifier(attributeToReplace, true, (IModel)srcReplacement));
    }
}

