/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;
import org.apache.wicket.model.Model;
import org.apache.wicket.version.undo.Change;

public class PagingNavigation
extends Loop {
    private static final long serialVersionUID = 1L;
    protected IPageable pageable;
    protected IPagingLabelProvider labelProvider;
    private int startIndex;
    private int margin = -1;
    private String separator = null;
    private int viewSize = 10;

    public PagingNavigation(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public PagingNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id, null);
        this.pageable = pageable;
        this.labelProvider = labelProvider;
        this.startIndex = 0;
    }

    public int getMargin() {
        if (this.margin == -1 && this.viewSize != 0) {
            return this.viewSize / 2;
        }
        return this.margin;
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getViewSize() {
        return this.viewSize;
    }

    public void setViewSize(int size) {
        this.viewSize = size;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    protected void onBeforeRender() {
        this.setModel(new Model(new Integer(this.pageable.getPageCount())));
        this.setStartIndex();
        super.onBeforeRender();
    }

    protected final int getStartIndex() {
        return this.startIndex;
    }

    protected void populateItem(Loop.LoopItem loopItem) {
        int pageIndex = this.getStartIndex() + loopItem.getIteration();
        Link link = this.newPagingNavigationLink("pageLink", this.pageable, pageIndex);
        loopItem.add(link);
        String label = "";
        label = this.labelProvider != null ? this.labelProvider.getPageLabel(pageIndex) : String.valueOf(pageIndex + 1);
        link.add(new Label("pageNumber", label));
    }

    protected Link newPagingNavigationLink(String id, IPageable pageable, int pageIndex) {
        return new PagingNavigationLink(id, pageable, pageIndex){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return super.isEnabled() && PagingNavigation.this.isEnabled() && PagingNavigation.this.isEnableAllowed();
            }
        };
    }

    protected void renderItem(Loop.LoopItem loopItem) {
        super.renderItem(loopItem);
        if (this.separator != null && loopItem.getIteration() != this.getIterations() - 1) {
            this.getResponse().write(this.separator);
        }
    }

    private void setStartIndex() {
        int firstListItem = this.startIndex;
        int viewSize = Math.min(this.getViewSize(), this.pageable.getPageCount());
        int margin = this.getMargin();
        int currentPage = this.pageable.getCurrentPage();
        if (currentPage < firstListItem + margin) {
            firstListItem = currentPage - margin;
        } else if (currentPage >= firstListItem + viewSize - margin) {
            firstListItem = currentPage + margin + 1 - viewSize;
        }
        if (firstListItem + viewSize >= this.pageable.getPageCount()) {
            firstListItem = this.pageable.getPageCount() - viewSize;
        }
        if (firstListItem < 0) {
            firstListItem = 0;
        }
        if (viewSize != this.getIterations() || this.startIndex != firstListItem) {
            this.modelChanging();
            this.addStateChange(new StartIndexChange(this.startIndex));
            this.startIndex = firstListItem;
            this.setIterations(Math.min(viewSize, this.pageable.getPageCount()));
            this.modelChanged();
            this.removeAll();
        }
    }

    private void setIterations(int i) {
        this.setModelObject(new Integer(i));
    }

    private final class StartIndexChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final int startIndex;

        private StartIndexChange(int startIndex) {
            this.startIndex = startIndex;
        }

        public final void undo() {
            PagingNavigation.this.startIndex = this.startIndex;
        }

        public String toString() {
            return "StartIndexChange[component: " + PagingNavigation.this.getPath() + ", prefix: " + this.startIndex + "]";
        }
    }
}

